/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.config;

import java.io.File;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.spin.tools.JAXBUtils;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;

@XmlRootElement(name="ProjectMappings")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProjectMappings {
    public static String DEFAULT_PROJET = "default";
    private static String DEFAULT_MAPPINGS_FILENAME = "ProjectMappings.xml";
    private TreeMap<String, String> mappings = new TreeMap();
    private static ProjectMappings defaultInstance;
    private static final Logger log;
    private static final boolean DEBUG;
    private static final boolean INFO;

    public static ProjectMappings getDefaultInstance() throws ConfigException {
        if (defaultInstance != null) {
            if (DEBUG) {
                log.debug((Object)"getDefaultInstance() returning cached instance");
            }
        } else {
            defaultInstance = ProjectMappings.loadFromFile(DEFAULT_MAPPINGS_FILENAME);
        }
        return defaultInstance;
    }

    public static ProjectMappings loadFromFile(String mappingsFilename) throws ConfigException {
        return ProjectMappings.loadfromFile(ConfigTool.getConfigFileWithFailover((String)mappingsFilename));
    }

    public static ProjectMappings loadfromFile(File mappingsFile) throws ConfigException {
        ProjectMappings mappings = null;
        try {
            if (INFO) {
                log.info((Object)("Loading AdapterMappings from disk : " + mappingsFile.getAbsolutePath()));
            }
            mappings = (ProjectMappings)JAXBUtils.unmarshal((File)mappingsFile, ProjectMappings.class);
            return mappings;
        }
        catch (JAXBException jaxbe) {
            log.error((Object)"Unmarshalling error", (Throwable)jaxbe);
            throw new ConfigException("AdapterMappings unmarshalling error", (Throwable)jaxbe);
        }
    }

    public TreeMap<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(TreeMap<String, String> mappings) {
        this.mappings = mappings;
    }

    static {
        log = Logger.getLogger(ProjectMappings.class);
        DEBUG = log.isDebugEnabled();
        INFO = log.isInfoEnabled();
    }
}

