/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.identity;

import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.Signable;
import org.spin.tools.crypto.signature.XMLSignatureUtil;

public class CarraIdentityService
implements IdentityService {
    public Identity certify(String domain, String username, String password) throws IdentityServiceException {
        if (username == null || password == null) {
            throw new IdentityServiceException("No username or password");
        }
        try {
            Identity id = CarraIdentityService.convertAuthToIdentity(password);
            if (XMLSignatureUtil.getDefaultInstance().verifySignature((Signable)id) && username.equalsIgnoreCase(id.getUsername())) {
                Identity resignedIdentity = new Identity(id.getDomain(), id.getUsername(), id.getAssertion());
                resignedIdentity = XMLSignatureUtil.getDefaultInstance().sign(resignedIdentity);
                return resignedIdentity;
            }
            throw new IdentityServiceException("Not authorized");
        }
        catch (Exception e) {
            throw new IdentityServiceException("Not authorized");
        }
    }

    private static Identity convertAuthToIdentity(String authHeaderString) throws JAXBException, UnsupportedEncodingException, DecoderException {
        Base64 base64 = new Base64();
        byte[] byteArray = base64.decode(authHeaderString);
        String xmlIdentity = new String(byteArray, "UTF-8");
        return (Identity)JAXBUtils.unmarshal((String)xmlIdentity, Identity.class);
    }
}

