/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.model;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import net.shrine.sheriff.model.Constants;
import net.shrine.sheriff.model.Sheriff;
import net.shrine.sheriff.model.SheriffEntry;
import net.shrine.sheriff.model.SheriffException;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.XMLSignatureUtil;

public class SheriffClientFacade {
    private String url = null;

    public SheriffClientFacade() {
    }

    public SheriffClientFacade(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
    }

    private Identity signIdentity(String ecommonsID) throws XMLSignatureException {
        try {
            XMLSignatureUtil instance = XMLSignatureUtil.getDefaultInstance();
            return instance.sign(new Identity("HOME_INSTITUTION", ecommonsID));
        }
        catch (ConfigException e) {
            throw new XMLSignatureException("Error creating XMLSignatureUtil");
        }
    }

    private Sheriff getPort() throws IOException {
        Service service = Service.create((URL)new URL(this.url), (QName)Constants.QserviceName);
        return (Sheriff)service.getPort(Constants.QportName, Sheriff.class);
    }

    public List<SheriffEntry> readApprovedEntries(String ecommonsID) throws SheriffException {
        try {
            return this.readApprovedEntries(this.signIdentity(ecommonsID));
        }
        catch (XMLSignatureException e) {
            throw new SheriffException(e);
        }
    }

    public List<SheriffEntry> readApprovedEntries(Identity identity) throws SheriffException {
        try {
            return this.getPort().readApprovedEntries(identity);
        }
        catch (Exception e) {
            throw new SheriffException(e);
        }
    }

    public SheriffEntry readApprovedTopic(String ecommonsID, Integer queryTopicID) throws SheriffException {
        try {
            return this.getPort().readApprovedTopic(this.signIdentity(ecommonsID), queryTopicID);
        }
        catch (Exception e) {
            throw new SheriffException(e);
        }
    }
}

