/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlRootElement;
import net.shrine.sheriff.model.ApprovalStatus;
import net.shrine.sheriff.model.RoleLevel;

@XmlRootElement
@Entity
public class SheriffEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int maxStringColumnLength = 30000;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long queryTopicID;
    @Column(nullable=true)
    private RoleLevel role;
    @Column(nullable=false)
    private String eCommonsID;
    @Column(nullable=true)
    private String email;
    @Column(nullable=false)
    private String queryName;
    @Column(nullable=false, length=30000)
    private String queryIntent;
    @Column(nullable=false)
    private ApprovalStatus approval;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date requestedTimestamp;
    @Column(nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date approvalTimestamp;
    @Column(nullable=true, length=30000)
    private String note;
    @Column(nullable=true)
    private Long parentId;
    @Column(nullable=true, length=30000)
    private String followUp;
    @Column(nullable=true, length=30000)
    private String queryReason;
    @Column(nullable=true, length=30000)
    private String queryReasonOther;
    @Column(nullable=true)
    private Boolean hasNonShrineCollaborator = false;
    @Column(nullable=true, length=30000)
    private String nonShrineCollaboratorInfo;
    @Column(nullable=false, unique=true)
    private String protocolNumber;

    public Long getQueryTopicID() {
        return this.queryTopicID;
    }

    public void setQueryTopicID(Long queryTopicID) {
        this.queryTopicID = queryTopicID;
    }

    public String getECommonsID() {
        return this.eCommonsID;
    }

    public void setECommonsID(String eCommonsID) {
        this.eCommonsID = eCommonsID;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public ApprovalStatus getApproval() {
        return this.approval;
    }

    public void setApproval(ApprovalStatus approval) {
        this.approval = approval;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public String getQueryIntent() {
        return this.queryIntent;
    }

    public void setQueryIntent(String queryIntent) {
        this.queryIntent = queryIntent;
    }

    public RoleLevel getRole() {
        return this.role;
    }

    public void setRole(RoleLevel role) {
        this.role = role;
    }

    public Date getRequestedTimestamp() {
        return this.requestedTimestamp;
    }

    public void setRequestedTimestamp(Date requestedTimestamp) {
        this.requestedTimestamp = requestedTimestamp;
    }

    public Date getApprovalTimestamp() {
        return this.approvalTimestamp;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setApprovalTimestamp(Date approvalTimestamp) {
        this.approvalTimestamp = approvalTimestamp;
    }

    public String getProtocolNumber() {
        return this.protocolNumber;
    }

    public int getProtocolNumberOrdinal() {
        return Integer.parseInt(this.getProtocolNumber().split("-")[1]);
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public void setProtocolNumber(int year, int number) {
        this.protocolNumber = String.format("%1$04d-%2$04d", year, number);
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getFollowUp() {
        return this.followUp;
    }

    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    public String getQueryReason() {
        return this.queryReason;
    }

    public void setQueryReason(String queryReason) {
        this.queryReason = queryReason;
    }

    public String getQueryReasonOther() {
        return this.queryReasonOther;
    }

    public void setQueryReasonOther(String queryReasonOther) {
        this.queryReasonOther = queryReasonOther;
    }

    public boolean getHasNonShrineCollaborator() {
        return this.hasNonShrineCollaborator;
    }

    public void setHasNonShrineCollaborator(boolean hasNonShrineCollaborator) {
        this.hasNonShrineCollaborator = hasNonShrineCollaborator;
    }

    public String getNonShrineCollaboratorInfo() {
        return this.nonShrineCollaboratorInfo;
    }

    public void setNonShrineCollaboratorInfo(String nonShrineCollaboratorInfo) {
        this.nonShrineCollaboratorInfo = nonShrineCollaboratorInfo;
    }

    public boolean deepEquals(SheriffEntry that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        if (this.queryTopicID != null ? !this.queryTopicID.equals(that.queryTopicID) : that.queryTopicID != null) {
            return false;
        }
        if (this.eCommonsID != null ? !this.eCommonsID.equals(that.eCommonsID) : that.eCommonsID != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.role != null ? !this.role.equals((Object)that.role) : that.role != null) {
            return false;
        }
        if (this.queryName != null ? !this.queryName.equals(that.queryName) : that.queryName != null) {
            return false;
        }
        if (this.note != null ? !this.note.equals(that.note) : that.note != null) {
            return false;
        }
        if (this.queryIntent != null ? !this.queryIntent.equals(that.queryIntent) : that.queryIntent != null) {
            return false;
        }
        if (this.requestedTimestamp != null ? !this.requestedTimestamp.equals(that.requestedTimestamp) : that.requestedTimestamp != null) {
            return false;
        }
        if (this.approvalTimestamp != null ? !this.approvalTimestamp.equals(that.approvalTimestamp) : that.approvalTimestamp != null) {
            return false;
        }
        if (this.parentId != null ? !this.parentId.equals(that.parentId) : that.parentId != null) {
            return false;
        }
        return !(this.followUp != null ? !this.followUp.equals(that.followUp) : that.followUp != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.queryTopicID == null ? 0 : this.queryTopicID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SheriffEntry other = (SheriffEntry)obj;
        return !(this.queryTopicID == null ? other.queryTopicID != null : !this.queryTopicID.equals(other.queryTopicID));
    }

    static String stripLinefeeds(String input) {
        String ret = "";
        if (input != null) {
            ret = input.replaceAll("[\r\n]+", " ");
        }
        return ret;
    }

    public String toString() {
        return this.display("SheriffEntry [", "=", ", ", "]");
    }

    public String display(String prefix, String kvseparator, String propertyseparator, String suffix) {
        StringBuffer sb = new StringBuffer(prefix);
        sb.append("queryTopicID").append(kvseparator).append(String.valueOf(this.queryTopicID)).append(propertyseparator);
        sb.append("protocolNumber").append(kvseparator).append(String.valueOf(this.protocolNumber)).append(propertyseparator);
        sb.append("eCommonsID").append(kvseparator).append(String.valueOf(this.eCommonsID)).append(propertyseparator);
        sb.append("Email").append(kvseparator).append(String.valueOf(this.email)).append(propertyseparator);
        sb.append("requestedTimestamp").append(kvseparator).append(String.valueOf(this.requestedTimestamp)).append(propertyseparator);
        sb.append("queryName").append(kvseparator).append(SheriffEntry.stripLinefeeds(String.valueOf(this.queryName))).append(propertyseparator);
        sb.append("approval").append(kvseparator).append(this.approval != null ? this.approval.name() : "null").append(propertyseparator);
        sb.append("approvalTimestamp").append(kvseparator).append(String.valueOf(this.approvalTimestamp)).append(propertyseparator);
        sb.append("queryIntent").append(kvseparator).append(SheriffEntry.stripLinefeeds(String.valueOf(this.queryIntent))).append(propertyseparator);
        sb.append("queryReason").append(kvseparator).append(SheriffEntry.stripLinefeeds(String.valueOf(this.queryReason))).append(propertyseparator);
        sb.append("queryReasonOther").append(kvseparator).append(SheriffEntry.stripLinefeeds(String.valueOf(this.queryReasonOther))).append(propertyseparator);
        sb.append("note").append(kvseparator).append(SheriffEntry.stripLinefeeds(String.valueOf(this.note))).append(propertyseparator);
        sb.append("followUp").append(kvseparator).append(SheriffEntry.stripLinefeeds(String.valueOf(this.followUp))).append(propertyseparator);
        sb.append("hasNonShrineCollaborator").append(kvseparator).append(String.valueOf(this.hasNonShrineCollaborator)).append(propertyseparator);
        sb.append("nonShrineCollaboratorInfo").append(kvseparator).append(SheriffEntry.stripLinefeeds(String.valueOf(this.nonShrineCollaboratorInfo))).append(propertyseparator);
        sb.append("parentId").append(kvseparator).append(String.valueOf(this.parentId)).append(propertyseparator);
        sb.append("role").append(kvseparator).append(this.role != null ? this.role.name() : "null").append(propertyseparator);
        return sb.append(suffix).toString();
    }
}

