/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spin.tools.Observable;
import org.spin.tools.Observer;
import org.spin.tools.Util;

public final class ObserverSet
implements Observable,
Iterable<Observer> {
    private final List<WeakReference<Observer>> observers = Util.makeArrayList(5);

    @Override
    public Iterator<Observer> iterator() {
        return new Iterator<Observer>(){
            private final Iterator<WeakReference<Observer>> delegate;
            {
                this.delegate = Util.makeArrayList(ObserverSet.this.observers).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Observer next() {
                return (Observer)this.delegate.next().get();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() is not supported.  See ObserverSet.noLongerObservedBy() instead");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void informObservers() {
        List<WeakReference<Observer>> list = this.observers;
        synchronized (list) {
            ArrayList<WeakReference<Observer>> defensiveCopy = Util.makeArrayList(this.observers);
            for (WeakReference weakReference : defensiveCopy) {
                Observer observer = (Observer)weakReference.get();
                if (observer == null) continue;
                observer.inform();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void observedBy(Observer observer) {
        Util.guardNotNull(observer);
        List<WeakReference<Observer>> list = this.observers;
        synchronized (list) {
            this.observers.add(new WeakReference<Observer>(observer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noLongerObservedBy(Observer observer) {
        Util.guardNotNull(observer);
        List<WeakReference<Observer>> list = this.observers;
        synchronized (list) {
            ArrayList toRemove = Util.makeArrayList(this.observers.size());
            for (WeakReference<Observer> ref : this.observers) {
                if (!observer.equals(ref.get())) continue;
                toRemove.add(ref);
            }
            this.observers.removeAll(toRemove);
        }
    }
}

