/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto.signature;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.spin.tools.crypto.signature.KeyInfo;
import org.spin.tools.crypto.signature.SignatureValue;
import org.spin.tools.crypto.signature.SignedInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SignatureType")
public final class Signature {
    @XmlElement(name="SignedInfo", required=true)
    protected final SignedInfo signedInfo;
    @XmlElement(name="SignatureValue", required=true)
    protected final SignatureValue signatureValue;
    @XmlElement(name="KeyInfo", required=true)
    protected final KeyInfo keyInfo;
    @XmlAttribute(name="Id")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected final String id;
    public static final Signature Bad = new Signature();

    private Signature() {
        this(null, null, null, null);
    }

    public Signature(SignedInfo signedInfo, SignatureValue signatureValue, KeyInfo keyInfo, String id) {
        this.signedInfo = signedInfo;
        this.signatureValue = signatureValue;
        this.keyInfo = keyInfo;
        this.id = id;
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public SignatureValue getSignatureValue() {
        return this.signatureValue;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.keyInfo == null ? 0 : this.keyInfo.hashCode());
        result = 31 * result + (this.signatureValue == null ? 0 : this.signatureValue.hashCode());
        result = 31 * result + (this.signedInfo == null ? 0 : this.signedInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.keyInfo == null ? other.keyInfo != null : !this.keyInfo.equals(other.keyInfo)) {
            return false;
        }
        if (this.signatureValue == null ? other.signatureValue != null : !this.signatureValue.equals(other.signatureValue)) {
            return false;
        }
        return !(this.signedInfo == null ? other.signedInfo != null : !this.signedInfo.equals(other.signedInfo));
    }
}

