/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.spin.tools.Util;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QueryPerformanceInfo")
@XmlRootElement
public final class QueryPerformanceInfo {
    private static final Logger log = Logger.getLogger(QueryPerformanceInfo.class);
    private final List<Integer> executionHistogram = Util.makeArrayList();
    private final long minExecutionTime = 0L;
    private final int numHistogramBins;
    private final int countOfOccurrences;
    private final long maxExecutionTime;
    private final BigDecimal scale;
    private final long medianExecutionTime;
    private final BigDecimal meanExecutionTime;
    private final BigDecimal stdDevExecutionTime;

    private QueryPerformanceInfo() {
        this.numHistogramBins = 0;
        this.countOfOccurrences = 0;
        this.maxExecutionTime = 0L;
        this.scale = null;
        this.medianExecutionTime = 0L;
        this.meanExecutionTime = null;
        this.stdDevExecutionTime = null;
    }

    public QueryPerformanceInfo(long executionTime) {
        if (executionTime < 0L) {
            log.error((Object)("Execution time cannot be less than 0 ('" + executionTime + "')"));
            throw new IllegalArgumentException("Execution time cannot be less than 0 ('" + executionTime + "')");
        }
        this.numHistogramBins = 64;
        BigDecimal tempScale = new BigDecimal(executionTime + "");
        tempScale = tempScale.multiply(new BigDecimal("2"));
        this.scale = tempScale.divide(new BigDecimal(this.numHistogramBins + ""), 4, RoundingMode.HALF_EVEN);
        this.maxExecutionTime = (long)(this.scale.doubleValue() * (double)this.numHistogramBins);
        this.fillWithZeros(this.executionHistogram, this.numHistogramBins);
        this.updateHistogram(executionTime);
        this.countOfOccurrences = 1;
        this.medianExecutionTime = this.caluclateMedianExecutionTime();
        this.meanExecutionTime = this.calculateMeanValue();
        this.stdDevExecutionTime = this.calculateStandardDeviation();
    }

    public QueryPerformanceInfo(QueryPerformanceInfo oldInfo, long executionTime) {
        if (executionTime < 0L) {
            log.error((Object)("Execution time cannot be less than 0 ('" + executionTime + "')"));
            throw new IllegalArgumentException("Execution time cannot be less than 0 ('" + executionTime + "')");
        }
        this.scale = oldInfo.scale;
        this.executionHistogram.addAll(oldInfo.executionHistogram);
        if (executionTime > oldInfo.maxExecutionTime) {
            this.numHistogramBins = oldInfo.numHistogramBins + this.increaseHistogram(oldInfo.maxExecutionTime, executionTime);
            this.maxExecutionTime = executionTime;
        } else {
            this.numHistogramBins = oldInfo.numHistogramBins;
            this.maxExecutionTime = oldInfo.maxExecutionTime;
        }
        this.updateHistogram(executionTime);
        this.countOfOccurrences = this.countTotalNumOfOccurrences();
        this.medianExecutionTime = this.caluclateMedianExecutionTime();
        this.meanExecutionTime = this.calculateMeanValue();
        this.stdDevExecutionTime = this.calculateStandardDeviation();
    }

    public BigDecimal getTestScale() {
        return this.scale;
    }

    private final int calculateMedianIndex() {
        double tempMedianIndex = (double)this.countOfOccurrences / 2.0;
        int binIndex = 0;
        while (tempMedianIndex > 0.0) {
            tempMedianIndex -= (double)this.executionHistogram.get(binIndex).intValue();
            ++binIndex;
        }
        return binIndex - 1;
    }

    private final long caluclateMedianExecutionTime() {
        int medianIndex = this.calculateMedianIndex();
        return (long)((double)medianIndex * this.scale.doubleValue());
    }

    private final BigDecimal calculateMeanValue() {
        BigDecimal sumExecutionTimes = BigDecimal.ZERO;
        for (int index = 0; index < this.executionHistogram.size(); ++index) {
            if (this.executionHistogram.get(index) <= 0) continue;
            BigDecimal sumAtIndex = this.scale.multiply(new BigDecimal(index * this.executionHistogram.get(index)));
            sumExecutionTimes = sumExecutionTimes.add(sumAtIndex);
        }
        return sumExecutionTimes.divide(new BigDecimal(this.countOfOccurrences + ""), 4, RoundingMode.HALF_EVEN);
    }

    private final BigDecimal calculateVariance() {
        if (this.meanExecutionTime == null) {
            log.error((Object)"Mean execution time must be calculated & set prior to calculating standard deviation.");
            return null;
        }
        BigDecimal variance = BigDecimal.ZERO;
        for (int index = 0; index < this.executionHistogram.size(); ++index) {
            BigDecimal tempVariance = new BigDecimal(index);
            tempVariance = tempVariance.multiply(this.scale);
            tempVariance = tempVariance.subtract(this.meanExecutionTime);
            tempVariance = tempVariance.pow(2);
            tempVariance = tempVariance.multiply(new BigDecimal(this.executionHistogram.get(index)));
            variance = variance.add(tempVariance);
        }
        return variance.divide(new BigDecimal(this.countOfOccurrences), 0, RoundingMode.HALF_EVEN);
    }

    private final BigDecimal calculateStandardDeviation() {
        return new BigDecimal(Math.sqrt(this.calculateVariance().doubleValue()));
    }

    private final int countTotalNumOfOccurrences() {
        ArrayList copyOfHistogram = Util.makeArrayList(this.executionHistogram);
        int sum = 0;
        for (Integer numHits : copyOfHistogram) {
            sum += numHits.intValue();
        }
        return sum;
    }

    private final int increaseHistogram(long oldMaxExecutionTime, long executionTime) {
        BigDecimal numBinsToAdd = new BigDecimal(executionTime - oldMaxExecutionTime).divide(this.scale, 0, RoundingMode.HALF_UP).add(BigDecimal.ONE);
        ArrayList addHistogramBins = Util.makeArrayList();
        this.fillWithZeros(addHistogramBins, numBinsToAdd.intValue());
        this.executionHistogram.addAll(this.executionHistogram.size(), addHistogramBins);
        return numBinsToAdd.intValue();
    }

    private final void fillWithZeros(List<Integer> listToBeFilled, int numZerosToFill) {
        for (int index = 0; index < numZerosToFill; ++index) {
            listToBeFilled.add(0);
        }
    }

    private final void updateHistogram(long executionTime) {
        BigDecimal binToUpdate = new BigDecimal(executionTime).divide(this.scale, 0, RoundingMode.HALF_UP);
        if (binToUpdate.intValueExact() >= this.executionHistogram.size()) {
            return;
        }
        this.executionHistogram.set(binToUpdate.intValueExact(), this.executionHistogram.get(binToUpdate.intValueExact()) + 1);
    }

    final BigDecimal getScale() {
        return this.scale;
    }

    final int getNumHistogramBins() {
        return this.numHistogramBins;
    }

    final List<Integer> getExecutionHistogram() {
        return Util.makeArrayList(this.executionHistogram);
    }

    final long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public final long getMedianExecutionTime() {
        return this.medianExecutionTime;
    }

    public final BigDecimal getMeanExecutionTime() {
        return this.meanExecutionTime;
    }

    public final BigDecimal getStdDevExecutionTime() {
        return this.stdDevExecutionTime;
    }

    public final int getCount() {
        return this.countOfOccurrences;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.countOfOccurrences;
        result = 31 * result + (this.executionHistogram == null ? 0 : ((Object)this.executionHistogram).hashCode());
        result = 31 * result + (int)(this.maxExecutionTime ^ this.maxExecutionTime >>> 32);
        result = 31 * result + (this.meanExecutionTime == null ? 0 : this.meanExecutionTime.hashCode());
        result = 31 * result + (int)(this.medianExecutionTime ^ this.medianExecutionTime >>> 32);
        result = 31 * result + 0;
        result = 31 * result + this.numHistogramBins;
        result = 31 * result + (this.scale == null ? 0 : this.scale.hashCode());
        result = 31 * result + (this.stdDevExecutionTime == null ? 0 : this.stdDevExecutionTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryPerformanceInfo other = (QueryPerformanceInfo)obj;
        if (this.countOfOccurrences != other.countOfOccurrences) {
            return false;
        }
        if (this.executionHistogram == null ? other.executionHistogram != null : !((Object)this.executionHistogram).equals(other.executionHistogram)) {
            return false;
        }
        if (this.maxExecutionTime != other.maxExecutionTime) {
            return false;
        }
        if (this.meanExecutionTime == null ? other.meanExecutionTime != null : !this.meanExecutionTime.equals(other.meanExecutionTime)) {
            return false;
        }
        if (this.medianExecutionTime != other.medianExecutionTime) {
            return false;
        }
        if (0L != other.minExecutionTime) {
            return false;
        }
        if (this.numHistogramBins != other.numHistogramBins) {
            return false;
        }
        if (this.scale == null ? other.scale != null : !this.scale.equals(other.scale)) {
            return false;
        }
        return !(this.stdDevExecutionTime == null ? other.stdDevExecutionTime != null : !this.stdDevExecutionTime.equals(other.stdDevExecutionTime));
    }
}

