/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.connector;

import java.util.Collection;
import java.util.EnumSet;
import org.spin.node.NodeException;
import org.spin.node.NodeStatusInfo;
import org.spin.node.SpinNode;
import org.spin.node.acknack.AckNack;
import org.spin.node.actions.QueryException;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.cache.StatusCode;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.QueryInput;
import org.spin.query.message.headers.Result;
import org.spin.query.message.headers.ResultSet;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.tools.crypto.signature.Identity;

public final class DefensiveCopyNodeConnector
extends NodeConnector {
    private final SpinNode node;

    @Override
    public String debug(String queryID) {
        return this.node.debug(queryID);
    }

    DefensiveCopyNodeConnector(SpinNode node) throws NodeException {
        this(node, "localhost");
    }

    private DefensiveCopyNodeConnector(SpinNode node, String nodeName) throws NodeException {
        super(nodeName);
        if (node == null) {
            throw new NodeException("Null SpinNode passed in");
        }
        this.node = node;
    }

    @Override
    public void aggregate(QueryInfo queryInfo, Result resultData) throws CacheException {
        this.node.aggregate(QueryInfo.copyOf((QueryInfo)queryInfo), resultData);
    }

    @Override
    public Identity certify(String username, String password, String role) throws IdentityServiceException {
        return this.node.certify(username, password, role);
    }

    @Override
    public int countResponses(String queryID) throws CacheException, QueryNotFoundException {
        return this.node.countResponses(queryID);
    }

    @Override
    public void expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, int numChildren) throws CacheException {
        this.node.expectResponse(QueryInfo.copyOf((QueryInfo)queryInfo), EnumSet.copyOf(statuses), numChildren);
    }

    @Override
    public ResultSet getResult(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.node.getResult(queryID, Identity.copyOf((Identity)requestorID));
    }

    @Override
    public ResultSet getResultNoDelete(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.node.getResultNoDelete(queryID, Identity.copyOf((Identity)requestorID));
    }

    @Override
    public boolean hasUpdate(String queryID, int numResponders) throws CacheException, QueryNotFoundException {
        return this.node.hasUpdate(queryID, numResponders);
    }

    @Override
    public void initQuery(QueryInfo queryInfo) {
        this.node.initQuery(QueryInfo.copyOf((QueryInfo)queryInfo));
    }

    @Override
    public boolean isComplete(String queryID) throws CacheException, QueryNotFoundException {
        return this.node.isComplete(queryID);
    }

    @Override
    public AckNack query(QueryInfo queryInfo, QueryInput criteria) throws QueryException {
        return this.node.query(QueryInfo.copyOf((QueryInfo)queryInfo), criteria);
    }

    @Override
    public ResultSet blockingQuery(QueryInfo queryInfo, QueryInput criteria) throws QueryException {
        return this.node.blockingQuery(QueryInfo.copyOf((QueryInfo)queryInfo), criteria);
    }

    @Override
    public NodeStatusInfo getNodeStatus() {
        return this.node.getNodeStatus();
    }
}

