/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.criteria;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.spin.query.message.criteria.SPINLogCriteria;
import org.spin.tools.QueryStatus;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.CertID;

public final class SpinLogCriteriaBuilder {
    private Date receivedStartDate;
    private Date receivedEndDate;
    private Date completedStartDate;
    private Date completedEndDate;
    private final List<String> queryIDs = Util.makeArrayList();
    private final List<String> peerGroups = Util.makeArrayList();
    private final List<String> queryTypes = Util.makeArrayList();
    private final List<String> usernames = Util.makeArrayList();
    private final List<String> memberships = Util.makeArrayList();
    private final List<String> roles = Util.makeArrayList();
    private final List<CertID> authenticators = Util.makeArrayList();
    private final List<QueryStatus> statuses = Util.makeArrayList();
    private final List<CertID> nodeIDs = Util.makeArrayList();

    private SpinLogCriteriaBuilder() {
    }

    public static final SpinLogCriteriaBuilder instance() {
        return new SpinLogCriteriaBuilder();
    }

    public SpinLogCriteriaBuilder receivedStartDate(Date receivedStartDate) {
        this.receivedStartDate = receivedStartDate;
        return this;
    }

    public SpinLogCriteriaBuilder receivedEndDate(Date receivedEndDate) {
        this.receivedEndDate = receivedEndDate;
        return this;
    }

    public SpinLogCriteriaBuilder completedStartDate(Date completedStartDate) {
        this.completedStartDate = completedStartDate;
        return this;
    }

    public SpinLogCriteriaBuilder completedEndDate(Date completedEndDate) {
        this.completedEndDate = completedEndDate;
        return this;
    }

    public SpinLogCriteriaBuilder queryIDs(List<String> queryIDs) {
        this.queryIDs.addAll(queryIDs);
        return this;
    }

    public SpinLogCriteriaBuilder queryIDs(String ... queryIDs) {
        return this.queryIDs(Arrays.asList(queryIDs));
    }

    public SpinLogCriteriaBuilder peerGroups(List<String> peerGroups) {
        this.peerGroups.addAll(peerGroups);
        return this;
    }

    public SpinLogCriteriaBuilder peerGroups(String ... peerGroups) {
        return this.peerGroups(Arrays.asList(peerGroups));
    }

    public SpinLogCriteriaBuilder queryTypes(List<String> queryTypes) {
        this.queryTypes.addAll(queryTypes);
        return this;
    }

    public SpinLogCriteriaBuilder queryTypes(String ... queryTypes) {
        return this.queryTypes(Arrays.asList(queryTypes));
    }

    public SpinLogCriteriaBuilder usernames(List<String> usernames) {
        this.usernames.addAll(usernames);
        return this;
    }

    public SpinLogCriteriaBuilder usernames(String ... usernames) {
        return this.usernames(Arrays.asList(usernames));
    }

    public SpinLogCriteriaBuilder memberships(List<String> memberships) {
        this.memberships.addAll(memberships);
        return this;
    }

    public SpinLogCriteriaBuilder memberships(String ... memberships) {
        return this.memberships(Arrays.asList(memberships));
    }

    public SpinLogCriteriaBuilder roles(List<String> roles) {
        this.roles.addAll(roles);
        return this;
    }

    public SpinLogCriteriaBuilder roles(String ... roles) {
        return this.roles(Arrays.asList(roles));
    }

    public SpinLogCriteriaBuilder authenticators(List<CertID> authenticators) {
        this.authenticators.addAll(authenticators);
        return this;
    }

    public SpinLogCriteriaBuilder authenticators(CertID ... authenticators) {
        return this.authenticators(Arrays.asList(authenticators));
    }

    public SpinLogCriteriaBuilder nodeIDs(List<CertID> nodeIDs) {
        this.nodeIDs.addAll(nodeIDs);
        return this;
    }

    public SpinLogCriteriaBuilder nodeIDs(CertID ... nodeIDs) {
        return this.nodeIDs(Arrays.asList(nodeIDs));
    }

    public SpinLogCriteriaBuilder statuses(List<QueryStatus> statuses) {
        this.statuses.addAll(statuses);
        return this;
    }

    public SpinLogCriteriaBuilder statuses(QueryStatus ... statuses) {
        return this.statuses(Arrays.asList(statuses));
    }

    public SPINLogCriteria build() {
        SPINLogCriteria criteria = new SPINLogCriteria();
        criteria.setReceivedStartDate(this.receivedStartDate);
        criteria.setReceivedEndDate(this.receivedEndDate);
        criteria.setCompletedStartDate(this.completedStartDate);
        criteria.setCompletedEndDate(this.completedEndDate);
        criteria.getQueryIDList().addAll(this.queryIDs);
        criteria.getPeerGroupList().addAll(this.peerGroups);
        criteria.getQueryTypeList().addAll(this.queryTypes);
        criteria.getMembershipList().addAll(this.memberships);
        criteria.getRoleList().addAll(this.roles);
        criteria.getUsernameList().addAll(this.usernames);
        criteria.getAuthenticatorList().addAll(this.authenticators);
        criteria.getNodeIDList().addAll(this.nodeIDs);
        criteria.getCompletionStatusList().addAll(this.statuses);
        return criteria;
    }

    public static final SPINLogCriteria makeReceivedDateRangeLogCriteria(Date receivedStartDate, Date receivedEndDate) {
        return SpinLogCriteriaBuilder.instance().receivedStartDate(receivedStartDate).receivedEndDate(receivedEndDate).build();
    }

    public static final SPINLogCriteria makeCompletedDateRangeLogCriteria(Date completedStartDate, Date completedEndDate) {
        return SpinLogCriteriaBuilder.instance().completedStartDate(completedStartDate).completedEndDate(completedEndDate).build();
    }

    public static final SPINLogCriteria makeQueryIDListLogCriteria(String ... queryIDs) {
        return SpinLogCriteriaBuilder.instance().queryIDs(queryIDs).build();
    }

    public static final SPINLogCriteria makePeerGroupListLogCriteria(String ... peerGroups) {
        return SpinLogCriteriaBuilder.instance().peerGroups(peerGroups).build();
    }

    public static final SPINLogCriteria makeQueryTypeListLogCriteria(String ... queryTypes) {
        return SpinLogCriteriaBuilder.instance().queryTypes(queryTypes).build();
    }

    public static final SPINLogCriteria makeUsernameListLogCriteria(String ... usernames) {
        return SpinLogCriteriaBuilder.instance().usernames(usernames).build();
    }

    public static final SPINLogCriteria makeMembershipListLogCriteria(String ... memberships) {
        return SpinLogCriteriaBuilder.instance().memberships(memberships).build();
    }

    public static final SPINLogCriteria makeRoleListLogCriteria(String ... roles) {
        return SpinLogCriteriaBuilder.instance().roles(roles).build();
    }

    public static final SPINLogCriteria makeAuthenticatorListLogCriteria(CertID ... authenticators) {
        return SpinLogCriteriaBuilder.instance().authenticators(authenticators).build();
    }

    public static final SPINLogCriteria makeStatusListLogCriteria(QueryStatus ... statuses) {
        return SpinLogCriteriaBuilder.instance().statuses(statuses).build();
    }

    public static final SPINLogCriteria makeNodeIDListLogCriteria(CertID ... nodeIDs) {
        return SpinLogCriteriaBuilder.instance().nodeIDs(nodeIDs).build();
    }
}

