/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.types;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.spin.node.dataaccess.types.IbatisLogEntryPK;
import org.spin.node.dataaccess.types.LogEntry;
import org.spin.query.message.headers.QueryInfo;
import org.spin.tools.QueryStatus;
import org.spin.tools.RandomTool;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LogEntry")
@XmlRootElement
public final class IbatisLogEntry
implements LogEntry<IbatisLogEntryPK> {
    private static final Logger log = Logger.getLogger(IbatisLogEntry.class);
    protected static final int maxStringColumnLength = 30000;
    @XmlElement(required=true)
    private IbatisLogEntryPK primaryKey;
    @XmlElement(required=false)
    private String peerGroup;
    @XmlElement(required=false)
    private String queryType;
    @XmlElement(required=true)
    private String username;
    @XmlElement(required=true)
    private String role;
    @XmlElement(required=true)
    private String domain;
    @XmlElement(required=true)
    private CertID authenticator;
    @XmlElement(required=true)
    private Date authenticatedTime;
    @XmlElement(required=false)
    private Boolean valid;
    @XmlElement(required=true)
    private Date receivedDate;
    @XmlElement(required=false)
    private Date completedDate;
    @XmlElement(required=false)
    private QueryStatus completionStatus;

    public IbatisLogEntry() {
        this(null, IbatisLogEntry.makeDummyQueryInfo(), false);
    }

    private static final QueryInfo makeDummyQueryInfo() {
        return new QueryInfo(RandomTool.randomString(), new Identity(), null);
    }

    public IbatisLogEntry(CertID nodeID, QueryInfo queryInfo, boolean valid) {
        Identity identity = queryInfo.getIdentity();
        this.primaryKey = new IbatisLogEntryPK(nodeID, queryInfo.getQueryID());
        this.peerGroup = IbatisLogEntry.truncateIfNecessary(queryInfo.getPeerGroup(), "Peer group was too long");
        this.queryType = IbatisLogEntry.truncateIfNecessary(queryInfo.getQueryType(), "Query type was too long");
        this.username = IbatisLogEntry.truncateIfNecessary(identity.getUsername(), "user name was too long");
        this.domain = IbatisLogEntry.truncateIfNecessary(identity.getDomain(), "Domain was too long");
        this.role = identity.getAssertion().size() > 0 ? IbatisLogEntry.truncateIfNecessary((String)identity.getAssertion().get(0), "Role/Assertion was too long") : "unknown";
        if (identity.getSignature() == null) {
            this.authenticator = null;
            this.authenticatedTime = null;
        } else {
            this.authenticator = IbatisLogEntry.truncateIfNecessary(identity.getSignature().getKeyInfo() != null ? identity.getSignature().getKeyInfo().getCertData().getCertID() : null, "Authenticator CertID name was too long");
            this.authenticatedTime = identity.getTimestamp() != null ? identity.getTimestamp().toGregorianCalendar().getTime() : null;
        }
        this.valid = valid ? Boolean.TRUE : Boolean.FALSE;
        this.receivedDate = new Date();
    }

    protected static final CertID truncateIfNecessary(CertID certID) {
        return IbatisLogEntry.truncateIfNecessary(certID, null);
    }

    protected static final CertID truncateIfNecessary(CertID certID, String message) {
        if (certID == null) {
            return null;
        }
        if (certID.getName().length() > 30000) {
            return new CertID(certID.getSerial(), IbatisLogEntry.truncateIfNecessary(certID.getName(), message));
        }
        return certID;
    }

    protected static final String truncateIfNecessary(String s) {
        return IbatisLogEntry.truncateIfNecessary(s, null);
    }

    protected static final String truncateIfNecessary(String s, String message) {
        if (s == null) {
            return null;
        }
        if (s.length() > 30000) {
            log.warn((Object)("Truncating String log data longer than 30000 characters: " + (message == null ? "" : message)));
            return s.substring(0, 30000);
        }
        return s;
    }

    public int hashCode() {
        return this.primaryKey == null ? 0 : this.primaryKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IbatisLogEntry other = (IbatisLogEntry)obj;
        return !(this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey));
    }

    protected static boolean equals(Date date1, Date date2) {
        if (date1 == null) {
            return date2 == null;
        }
        if (date2 == null) {
            return false;
        }
        long ms = Math.abs(date1.getTime() - date2.getTime());
        return ms < 1000L;
    }

    public boolean deepEquals(IbatisLogEntry other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey)) {
            return false;
        }
        if (this.authenticator == null ? other.authenticator != null : !this.authenticator.equals((Object)other.authenticator)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.peerGroup == null ? other.peerGroup != null : !this.peerGroup.equals(other.peerGroup)) {
            return false;
        }
        if (this.queryType == null ? other.queryType != null : !this.queryType.equals(other.queryType)) {
            return false;
        }
        if (this.role == null ? other.role != null : !this.role.equals(other.role)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        if (this.valid == null ? other.valid != null : !this.valid.equals(other.valid)) {
            return false;
        }
        if (this.completionStatus == null ? other.completionStatus != null : this.completionStatus != other.completionStatus) {
            return false;
        }
        if (!IbatisLogEntry.equals(this.authenticatedTime, other.authenticatedTime)) {
            return false;
        }
        if (!IbatisLogEntry.equals(this.receivedDate, other.receivedDate)) {
            return false;
        }
        return IbatisLogEntry.equals(this.completedDate, other.completedDate);
    }

    public final CertID getAuthenticator() {
        return this.authenticator;
    }

    public final void setAuthenticator(CertID authenticatedBy) {
        this.authenticator = authenticatedBy;
    }

    public final Date getAuthenticatedTime() {
        return this.authenticatedTime;
    }

    public final void setAuthenticatedTime(Date authenticatedTime) {
        this.authenticatedTime = authenticatedTime;
    }

    public final Date getReceivedDate() {
        return this.receivedDate;
    }

    public final void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate;
    }

    public final String getDomain() {
        return this.domain;
    }

    public final void setDomain(String domain) {
        this.domain = domain;
    }

    public final String getQueryID() {
        return this.primaryKey.getQueryID();
    }

    public final String getRole() {
        return this.role;
    }

    public final void setRole(String role) {
        this.role = role;
    }

    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final Boolean getValid() {
        return this.valid;
    }

    public final void setValid(Boolean valid) {
        this.valid = valid;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public QueryStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(QueryStatus completionStatus) {
        this.completionStatus = completionStatus;
    }

    public String getPeerGroup() {
        return this.peerGroup;
    }

    public void setPeerGroup(String peerGroup) {
        this.peerGroup = peerGroup;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public CertID getNodeID() {
        return this.primaryKey.getNodeID();
    }

    public IbatisLogEntryPK getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(IbatisLogEntryPK primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String toString() {
        return "[LogEntry: " + this.primaryKey.getQueryID() + " " + this.queryType + " " + this.username + " " + this.role + " " + this.domain + " " + this.receivedDate + "]";
    }
}

