/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.agent;

import org.spin.node.NodeConnectorSource;
import org.spin.query.message.agent.Credentials;
import org.spin.query.message.agent.StringSerializer;
import org.spin.query.message.headers.EncryptionParams;
import org.spin.query.message.identity.AlwaysCertifiesIdentityService;
import org.spin.query.message.identity.IdentityService;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.crypto.signature.CertID;

public final class SpinClientConfig {
    private final StringSerializer serializer;
    private final EncryptionParams encryptionParams;
    private final Long maxWaitTime;
    private final IdentityService identityService;
    private final Credentials credentials;
    private final EndpointConfig entryPoint;
    private final NodeConnectorSource nodeConnectorSource;
    public static final SpinClientConfig Default = new SpinClientConfig();

    private SpinClientConfig() {
        this(StringSerializer.JAXB, EncryptionParams.NoEncryption, AgentConfig.defaultMaxWaitTime, (IdentityService)AlwaysCertifiesIdentityService.Instance, null, null, NodeConnectorSource.Soap);
    }

    public SpinClientConfig(StringSerializer serializer, EncryptionParams encryptionParams, Long maxWaitTime, IdentityService identityService, Credentials credentials, EndpointConfig entryPoint, NodeConnectorSource nodeConnectorSource) {
        this.serializer = serializer;
        this.encryptionParams = encryptionParams;
        this.maxWaitTime = maxWaitTime;
        this.identityService = identityService;
        this.credentials = credentials;
        this.entryPoint = entryPoint;
        this.nodeConnectorSource = nodeConnectorSource;
    }

    public StringSerializer getSerializer() {
        return this.serializer;
    }

    public SpinClientConfig withSerializer(StringSerializer newSerializer) {
        return new SpinClientConfig(newSerializer, this.encryptionParams, this.maxWaitTime, this.identityService, this.credentials, this.entryPoint, this.nodeConnectorSource);
    }

    public EncryptionParams getEncryptionParams() {
        return this.encryptionParams;
    }

    public SpinClientConfig withEncryptionParams(EncryptionParams newEncryptionParams) {
        return new SpinClientConfig(this.serializer, newEncryptionParams, this.maxWaitTime, this.identityService, this.credentials, this.entryPoint, this.nodeConnectorSource);
    }

    public SpinClientConfig encryptedFor(CertID encryptFor) {
        return new SpinClientConfig(this.serializer, EncryptionParams.encryptFor((CertID)encryptFor), this.maxWaitTime, this.identityService, this.credentials, this.entryPoint, this.nodeConnectorSource);
    }

    public Long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public SpinClientConfig withMaxWaitTime(long newMaxWaitTime) {
        return new SpinClientConfig(this.serializer, this.encryptionParams, newMaxWaitTime, this.identityService, this.credentials, this.entryPoint, this.nodeConnectorSource);
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public SpinClientConfig withIdentityService(IdentityService newIdentityService) {
        return new SpinClientConfig(this.serializer, this.encryptionParams, this.maxWaitTime, newIdentityService, this.credentials, this.entryPoint, this.nodeConnectorSource);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public SpinClientConfig withCredentials(Credentials newCredentials) {
        return new SpinClientConfig(this.serializer, this.encryptionParams, this.maxWaitTime, this.identityService, newCredentials, this.entryPoint, this.nodeConnectorSource);
    }

    public EndpointConfig getEntryPoint() {
        return this.entryPoint;
    }

    public SpinClientConfig withEntryPoint(EndpointConfig newEntryPoint) {
        return new SpinClientConfig(this.serializer, this.encryptionParams, this.maxWaitTime, this.identityService, this.credentials, newEntryPoint, this.nodeConnectorSource);
    }

    public NodeConnectorSource getNodeConnectorSource() {
        return this.nodeConnectorSource;
    }

    public SpinClientConfig withNodeConnectorSource(NodeConnectorSource newNodeConnectorSource) {
        return new SpinClientConfig(this.serializer, this.encryptionParams, this.maxWaitTime, this.identityService, this.credentials, this.entryPoint, newNodeConnectorSource);
    }

    public String toString() {
        return "SpinClientConfig [serializer=" + this.serializer + ", encryptionParams=" + this.encryptionParams + ", maxWaitTime=" + this.maxWaitTime + ", identityService=" + this.identityService + ", credentials=" + this.credentials + ", entryPoint=" + this.entryPoint + "]";
    }
}

