/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.connector;

import java.net.URL;
import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.SpinNode;
import org.spin.node.connector.DefensiveCopyNodeConnector;
import org.spin.node.connector.LazyLoadingJAXWSNodeConnector;
import org.spin.tools.Util;
import org.spin.tools.config.AgentConfig;

public abstract class NodeConnector
implements SpinNode {
    private static final Logger log = Logger.getLogger(NodeConnector.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final String nodeName;

    NodeConnector(String nodeName) throws NodeException {
        if (nodeName == null) {
            throw new NodeException("Null node name passed in");
        }
        this.nodeName = nodeName;
    }

    public static final NodeConnector instance(String nodeWSDLURL) throws NodeException {
        return NodeConnector.instance(nodeWSDLURL, AgentConfig.defaultMaxWaitTime.intValue());
    }

    public static final NodeConnector instance(String nodeWSDLURL, int timeoutPeriod) throws NodeException {
        if (nodeWSDLURL == null) {
            throw new NodeException("Null Node URL passed in");
        }
        return new LazyLoadingJAXWSNodeConnector(nodeWSDLURL, timeoutPeriod);
    }

    public static final NodeConnector instance(URL nodeWSDLURL) throws NodeException {
        return NodeConnector.instance(nodeWSDLURL, AgentConfig.defaultMaxWaitTime.intValue());
    }

    public static final NodeConnector instance(URL nodeWSDLURL, int timeoutPeriod) throws NodeException {
        if (nodeWSDLURL == null) {
            throw new NodeException("Null Node URL passed in");
        }
        return new LazyLoadingJAXWSNodeConnector(nodeWSDLURL, timeoutPeriod);
    }

    public static final NodeConnector instance(SpinNode node) throws NodeException {
        if (node == null) {
            throw new NodeException("Null Node passed in");
        }
        return new DefensiveCopyNodeConnector(node);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    static boolean isSSL(URL nodeWSDLURL) {
        Util.guardNotNull((Object)nodeWSDLURL);
        return nodeWSDLURL.getProtocol().equalsIgnoreCase("https");
    }
}

