/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.MessageObserver;

public class ChainInitiationObserver
implements MessageObserver {
    protected Endpoint endpoint;
    protected Bus bus;
    private PhaseChainCache chainCache = new PhaseChainCache();

    public ChainInitiationObserver(Endpoint endpoint, Bus bus) {
        this.endpoint = endpoint;
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message m) {
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        try {
            PhaseInterceptorChain phaseChain = null;
            if (m.getInterceptorChain() instanceof PhaseInterceptorChain && (phaseChain = (PhaseInterceptorChain)m.getInterceptorChain()).getState() == InterceptorChain.State.PAUSED) {
                phaseChain.resume();
                return;
            }
            Message message = this.getBinding().createMessage(m);
            Exchange exchange = message.getExchange();
            if (exchange == null) {
                exchange = new ExchangeImpl();
                m.setExchange(exchange);
            }
            exchange.setInMessage(message);
            this.setExchangeProperties(exchange, message);
            InterceptorProvider dbp = null;
            if (this.endpoint.getService().getDataBinding() instanceof InterceptorProvider) {
                dbp = (InterceptorProvider)this.endpoint.getService().getDataBinding();
            }
            phaseChain = dbp == null ? this.chainCache.get(((PhaseManager)this.bus.getExtension(PhaseManager.class)).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getService().getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors()) : this.chainCache.get(((PhaseManager)this.bus.getExtension(PhaseManager.class)).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getService().getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors(), dbp.getInInterceptors());
            message.setInterceptorChain((InterceptorChain)phaseChain);
            phaseChain.setFaultObserver(this.endpoint.getOutFaultObserver());
            this.addToChain(phaseChain, message);
            phaseChain.doIntercept(message);
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
    }

    private void addToChain(PhaseInterceptorChain chain, Message m) {
        Collection is;
        Collection providers = CastUtils.cast((Collection)((Collection)m.get((Object)Message.INTERCEPTOR_PROVIDERS)));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                chain.add((Collection)p.getInInterceptors());
            }
        }
        if ((is = CastUtils.cast((Collection)((Collection)m.get((Object)Message.IN_INTERCEPTORS)))) != null) {
            chain.add(is);
        }
        if (m.getDestination() instanceof InterceptorProvider) {
            chain.add((Collection)((InterceptorProvider)m.getDestination()).getInInterceptors());
        }
    }

    protected Binding getBinding() {
        return this.endpoint.getBinding();
    }

    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Endpoint.class, (Object)this.endpoint);
        exchange.put(Service.class, (Object)this.endpoint.getService());
        exchange.put(Binding.class, (Object)this.getBinding());
        exchange.put(Bus.class, (Object)this.bus);
        if (exchange.getDestination() == null) {
            exchange.setDestination(m.getDestination());
        }
        if (this.endpoint != null && this.endpoint.getService() instanceof ServiceImpl) {
            EndpointInfo endpointInfo = this.endpoint.getEndpointInfo();
            QName serviceQName = endpointInfo.getService().getName();
            exchange.put((Object)"javax.xml.ws.wsdl.service", (Object)serviceQName);
            QName interfaceQName = endpointInfo.getService().getInterface().getName();
            exchange.put((Object)"javax.xml.ws.wsdl.interface", (Object)interfaceQName);
            QName portQName = endpointInfo.getName();
            exchange.put((Object)"javax.xml.ws.wsdl.port", (Object)portQName);
            URI wsdlDescription = (URI)endpointInfo.getProperty("URI", URI.class);
            if (wsdlDescription == null) {
                String address = endpointInfo.getAddress();
                try {
                    wsdlDescription = new URI(address + "?wsdl");
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                endpointInfo.setProperty("URI", (Object)wsdlDescription);
            }
            exchange.put((Object)"javax.xml.ws.wsdl.description", (Object)wsdlDescription);
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }
}

