/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.pm;

import edu.harvard.i2b2.crc.datavo.pm.UserType;
import net.shrine.serializers.pm.PMHttpClient;
import net.shrine.serializers.pm.PMSerializer;
import org.apache.log4j.Logger;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.XMLSignatureUtil;

public class PMIdentityService
implements IdentityService {
    public static final Logger log = Logger.getLogger(IdentityService.class);
    public static final boolean DEBUG = log.isDebugEnabled();
    public static final boolean INFO = log.isInfoEnabled();
    private final PMHttpClient pmClient;

    public PMIdentityService(PMHttpClient pmClient) throws ConfigException {
        this.pmClient = pmClient;
    }

    public Identity certify(String domain, String username, String password) throws IdentityServiceException {
        try {
            UserType userType = this.pmClient.getUserConfiguration(domain, username, password);
            if (userType == null) {
                throw new IdentityServiceException(String.format("User %s does not exist", username));
            }
            String ecommonsUsername = PMSerializer.extractEcommonsUsername(userType);
            if (ecommonsUsername == null) {
                throw new IdentityServiceException(String.format("No ecommons id for user %s", username));
            }
            Identity identity = new Identity(domain, ecommonsUsername);
            return XMLSignatureUtil.getDefaultInstance().sign(identity);
        }
        catch (Exception e) {
            throw new IdentityServiceException("Failed to certify user", (Throwable)e);
        }
    }
}

