/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.weaving.LoadTimeWeaverAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.instrument.classloading.InstrumentationLoadTimeWeaver;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.jdbc.datasource.lookup.MapDataSourceLookup;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitReader;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.SpringPersistenceUnitInfo;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistenceUnitManager
implements PersistenceUnitManager,
ResourceLoaderAware,
LoadTimeWeaverAware,
InitializingBean {
    public static final String DEFAULT_PERSISTENCE_XML_LOCATION = "classpath*:META-INF/persistence.xml";
    public static final String ORIGINAL_DEFAULT_PERSISTENCE_UNIT_ROOT_LOCATION = "classpath:";
    private static final boolean jpa2ApiPresent = ClassUtils.hasMethod(PersistenceUnitInfo.class, (String)"getSharedCacheMode", (Class[])new Class[0]);
    private String[] persistenceXmlLocations = new String[]{"classpath*:META-INF/persistence.xml"};
    private String defaultPersistenceUnitRootLocation = "classpath:";
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private DataSource defaultDataSource;
    private PersistenceUnitPostProcessor[] persistenceUnitPostProcessors;
    private LoadTimeWeaver loadTimeWeaver;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private final Set<String> persistenceUnitInfoNames = new HashSet<String>();
    private final Map<String, PersistenceUnitInfo> persistenceUnitInfos = new HashMap<String, PersistenceUnitInfo>();

    public void setPersistenceXmlLocation(String persistenceXmlLocation) {
        this.persistenceXmlLocations = new String[]{persistenceXmlLocation};
    }

    public void setPersistenceXmlLocations(String[] persistenceXmlLocations) {
        this.persistenceXmlLocations = persistenceXmlLocations;
    }

    public void setDefaultPersistenceUnitRootLocation(String defaultPersistenceUnitRootLocation) {
        this.defaultPersistenceUnitRootLocation = defaultPersistenceUnitRootLocation;
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        this.dataSourceLookup = new MapDataSourceLookup(dataSources);
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup != null ? dataSourceLookup : new JndiDataSourceLookup();
    }

    public DataSourceLookup getDataSourceLookup() {
        return this.dataSourceLookup;
    }

    public void setDefaultDataSource(DataSource defaultDataSource) {
        this.defaultDataSource = defaultDataSource;
    }

    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor[] postProcessors) {
        this.persistenceUnitPostProcessors = postProcessors;
    }

    public PersistenceUnitPostProcessor[] getPersistenceUnitPostProcessors() {
        return this.persistenceUnitPostProcessors;
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public LoadTimeWeaver getLoadTimeWeaver() {
        return this.loadTimeWeaver;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = resourceLoader != null ? ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader) : new PathMatchingResourcePatternResolver();
    }

    public void afterPropertiesSet() {
        if (this.loadTimeWeaver == null && InstrumentationLoadTimeWeaver.isInstrumentationAvailable()) {
            this.loadTimeWeaver = new InstrumentationLoadTimeWeaver(this.resourcePatternResolver.getClassLoader());
        }
        this.preparePersistenceUnitInfos();
    }

    public void preparePersistenceUnitInfos() {
        SpringPersistenceUnitInfo[] puis;
        this.persistenceUnitInfoNames.clear();
        this.persistenceUnitInfos.clear();
        SpringPersistenceUnitInfo[] springPersistenceUnitInfoArray = puis = this.readPersistenceUnitInfos();
        int n = puis.length;
        int n2 = 0;
        while (n2 < n) {
            SpringPersistenceUnitInfo pui = springPersistenceUnitInfoArray[n2];
            if (pui.getPersistenceUnitRootUrl() == null) {
                pui.setPersistenceUnitRootUrl(this.determineDefaultPersistenceUnitRootUrl());
            }
            if (pui.getNonJtaDataSource() == null) {
                pui.setNonJtaDataSource(this.defaultDataSource);
            }
            if (this.loadTimeWeaver != null) {
                pui.init(this.loadTimeWeaver);
            } else {
                pui.init(this.resourcePatternResolver.getClassLoader());
            }
            this.postProcessPersistenceUnitInfo(pui);
            String name = pui.getPersistenceUnitName();
            this.persistenceUnitInfoNames.add(name);
            SpringPersistenceUnitInfo puiToStore = pui;
            if (jpa2ApiPresent) {
                puiToStore = (PersistenceUnitInfo)Proxy.newProxyInstance(SmartPersistenceUnitInfo.class.getClassLoader(), new Class[]{SmartPersistenceUnitInfo.class}, (InvocationHandler)new Jpa2PersistenceUnitInfoDecorator(pui));
            }
            this.persistenceUnitInfos.put(name, puiToStore);
            ++n2;
        }
    }

    private SpringPersistenceUnitInfo[] readPersistenceUnitInfos() {
        PersistenceUnitReader reader = new PersistenceUnitReader(this.resourcePatternResolver, this.dataSourceLookup);
        return reader.readPersistenceUnitInfos(this.persistenceXmlLocations);
    }

    private URL determineDefaultPersistenceUnitRootUrl() {
        if (this.defaultPersistenceUnitRootLocation == null) {
            return null;
        }
        try {
            Resource res = this.resourcePatternResolver.getResource(this.defaultPersistenceUnitRootLocation);
            return res.getURL();
        }
        catch (IOException ex) {
            throw new PersistenceException("Unable to resolve persistence unit root URL", (Throwable)ex);
        }
    }

    protected final PersistenceUnitInfo getPersistenceUnitInfo(String persistenceUnitName) {
        return this.persistenceUnitInfos.get(persistenceUnitName);
    }

    protected void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        PersistenceUnitPostProcessor[] postProcessors = this.getPersistenceUnitPostProcessors();
        if (postProcessors != null) {
            PersistenceUnitPostProcessor[] persistenceUnitPostProcessorArray = postProcessors;
            int n = postProcessors.length;
            int n2 = 0;
            while (n2 < n) {
                PersistenceUnitPostProcessor postProcessor = persistenceUnitPostProcessorArray[n2];
                postProcessor.postProcessPersistenceUnitInfo(pui);
                ++n2;
            }
        }
    }

    @Override
    public PersistenceUnitInfo obtainDefaultPersistenceUnitInfo() {
        if (this.persistenceUnitInfoNames.isEmpty()) {
            throw new IllegalStateException("No persistence units parsed from " + ObjectUtils.nullSafeToString((Object[])this.persistenceXmlLocations));
        }
        if (this.persistenceUnitInfos.isEmpty()) {
            throw new IllegalStateException("All persistence units from " + ObjectUtils.nullSafeToString((Object[])this.persistenceXmlLocations) + " already obtained");
        }
        if (this.persistenceUnitInfos.size() > 1) {
            throw new IllegalStateException("No single default persistence unit defined in " + ObjectUtils.nullSafeToString((Object[])this.persistenceXmlLocations));
        }
        PersistenceUnitInfo pui = this.persistenceUnitInfos.values().iterator().next();
        this.persistenceUnitInfos.clear();
        return pui;
    }

    @Override
    public PersistenceUnitInfo obtainPersistenceUnitInfo(String persistenceUnitName) {
        PersistenceUnitInfo pui = this.persistenceUnitInfos.remove(persistenceUnitName);
        if (pui == null) {
            if (!this.persistenceUnitInfoNames.contains(persistenceUnitName)) {
                throw new IllegalArgumentException("No persistence unit with name '" + persistenceUnitName + "' found");
            }
            throw new IllegalStateException("Persistence unit with name '" + persistenceUnitName + "' already obtained");
        }
        return pui;
    }

    private static class Jpa2PersistenceUnitInfoDecorator
    implements InvocationHandler {
        private final SpringPersistenceUnitInfo target;
        private final Class<? extends Enum> sharedCacheModeEnum;
        private final Class<? extends Enum> validationModeEnum;

        public Jpa2PersistenceUnitInfoDecorator(SpringPersistenceUnitInfo target) {
            this.target = target;
            try {
                this.sharedCacheModeEnum = ClassUtils.forName((String)"javax.persistence.SharedCacheMode", (ClassLoader)PersistenceUnitInfo.class.getClassLoader());
                this.validationModeEnum = ClassUtils.forName((String)"javax.persistence.ValidationMode", (ClassLoader)PersistenceUnitInfo.class.getClassLoader());
            }
            catch (Exception ex) {
                throw new IllegalStateException("JPA 2.0 API enum types not present", ex);
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getSharedCacheMode")) {
                return Enum.valueOf(this.sharedCacheModeEnum, this.target.getSharedCacheModeName());
            }
            if (method.getName().equals("getValidationMode")) {
                return Enum.valueOf(this.validationModeEnum, this.target.getValidationModeName());
            }
            return method.invoke((Object)this.target, args);
        }
    }
}

