/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.cache;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.spin.query.message.cache.EhcacheMemoryResultStore;
import org.spin.query.message.cache.ResultStore;
import org.spin.query.message.cache.RootResponseNode;
import org.spin.query.message.cache.SimpleInMemoryResultStore;
import org.spin.query.message.headers.QueryInfo;
import org.spin.tools.RandomTool;
import org.spin.tools.Util;
import org.spin.tools.config.ResultStoreType;

public final class BenchmarkCaches {
    private static final Map<ResultStoreType, ResultStore> cacheTypes = Util.makeHashMap();
    private static final Map<ResultStoreType, List<BenchmarkMetric>> metrics = Util.makeHashMap();
    private static final int numElements = 1000000;
    private static final boolean outputToConsole = false;
    private static final String outputFileName = "/home/sophia/Documents/benchmarkCache1000000_" + RandomTool.randomString((int)5) + ".txt";

    private BenchmarkCaches() {
    }

    public static void main(String[] args) {
        BenchmarkCaches.initListOfCacheTypes();
        for (ResultStoreType resultStoreType : cacheTypes.keySet()) {
            ResultStore resultStore = cacheTypes.get(resultStoreType);
            ArrayList queryIDs = Util.makeArrayList();
            ArrayList metricsForOneType = Util.makeArrayList();
            BigDecimal startTime = new BigDecimal(System.nanoTime() + "");
            BigDecimal startHeapSize = new BigDecimal(Runtime.getRuntime().freeMemory() + "");
            System.out.print("Put...");
            for (int index = 0; index < 1000000; ++index) {
                String queryID = RandomTool.randomString((int)30);
                resultStore.put(queryID, new RootResponseNode(null, new QueryInfo()));
                if (index % RandomTool.randomInt((int)1, (int)200000) == 0) {
                    queryIDs.add(queryID);
                }
                if (index % 100000 != 0) continue;
                System.out.print(".");
            }
            BigDecimal timeElapsed = BenchmarkCaches.calculateTimeElapsed(System.nanoTime(), startTime);
            BigDecimal heapUsed = BenchmarkCaches.calculateHeapUsed(Runtime.getRuntime().freeMemory(), startHeapSize);
            metricsForOneType.add(new BenchmarkMetric(BenchmarkMetric.operationType.Put, timeElapsed, BenchmarkMetric.unitType.s));
            metricsForOneType.add(new BenchmarkMetric(BenchmarkMetric.operationType.Put, heapUsed, BenchmarkMetric.unitType.MB));
            System.out.println("\nGet...");
            startTime = new BigDecimal(System.nanoTime() + "");
            for (String queryID : queryIDs) {
                resultStore.get(queryID);
            }
            timeElapsed = BenchmarkCaches.calculateTimeElapsed(System.nanoTime(), startTime);
            heapUsed = BenchmarkCaches.calculateHeapUsed(Runtime.getRuntime().freeMemory(), startHeapSize);
            metricsForOneType.add(new BenchmarkMetric(BenchmarkMetric.operationType.Get, timeElapsed, BenchmarkMetric.unitType.s));
            metricsForOneType.add(new BenchmarkMetric(BenchmarkMetric.operationType.Get, heapUsed, BenchmarkMetric.unitType.MB));
            System.out.println("Contains...");
            startTime = new BigDecimal(System.nanoTime() + "");
            for (String queryID : queryIDs) {
                resultStore.containsQueryID(queryID);
            }
            timeElapsed = BenchmarkCaches.calculateTimeElapsed(System.nanoTime(), startTime);
            heapUsed = BenchmarkCaches.calculateHeapUsed(Runtime.getRuntime().freeMemory(), startHeapSize);
            metricsForOneType.add(new BenchmarkMetric(BenchmarkMetric.operationType.Contain, timeElapsed, BenchmarkMetric.unitType.s));
            metricsForOneType.add(new BenchmarkMetric(BenchmarkMetric.operationType.Contain, heapUsed, BenchmarkMetric.unitType.MB));
            System.out.println("Removes...");
            startTime = new BigDecimal(System.nanoTime() + "");
            for (String queryID : queryIDs) {
                resultStore.remove(queryID);
            }
            timeElapsed = BenchmarkCaches.calculateTimeElapsed(System.nanoTime(), startTime);
            heapUsed = BenchmarkCaches.calculateHeapUsed(Runtime.getRuntime().freeMemory(), startHeapSize);
            metricsForOneType.add(new BenchmarkMetric(BenchmarkMetric.operationType.Remove, timeElapsed, BenchmarkMetric.unitType.s));
            metricsForOneType.add(new BenchmarkMetric(BenchmarkMetric.operationType.Remove, heapUsed, BenchmarkMetric.unitType.MB));
            metrics.put(resultStoreType, metricsForOneType);
        }
        BenchmarkCaches.writeToFile(metrics);
    }

    private static final void writeToConsole(Map<ResultStoreType, List<BenchmarkMetric>> metrics) {
        System.out.println("Number of 'responseNodes' for benchmark: 1000000");
        System.out.println("=====");
        for (ResultStoreType resultStoreType : metrics.keySet()) {
            List<BenchmarkMetric> metricsForOneType = metrics.get(resultStoreType);
            System.out.println(resultStoreType.toString());
            for (BenchmarkMetric metric : metricsForOneType) {
                System.out.print("\t" + metric.getOperation() + "\t");
            }
            System.out.println("");
            System.out.print("\t");
            for (BenchmarkMetric metric : metricsForOneType) {
                System.out.print(metric.getMeasurement() + "(" + metric.getUnit() + ")\t");
            }
            System.out.println("");
        }
    }

    private static final void writeToFile(Map<ResultStoreType, List<BenchmarkMetric>> metrics) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFileName));
            out.write("Number of 'responseNodes' for benchmark: 1000000\n");
            for (ResultStoreType resultStoreType : metrics.keySet()) {
                List<BenchmarkMetric> metricsForOneType = metrics.get(resultStoreType);
                out.write("\t" + resultStoreType.toString() + "\n");
                for (BenchmarkMetric metric : metricsForOneType) {
                    out.write(metric.getOperation() + " (" + metric.getUnit().toString() + ")");
                    out.write("\t" + metric.getMeasurement().toString() + "\n");
                }
            }
            out.close();
        }
        catch (IOException e) {
            System.out.println("Could not write to file '" + outputFileName + "'");
            e.printStackTrace();
            BenchmarkCaches.writeToConsole(metrics);
        }
    }

    private static final BigDecimal calculateTimeElapsed(long nowTime, BigDecimal startTime) {
        BigDecimal elapsed = new BigDecimal(nowTime + "");
        elapsed = elapsed.subtract(startTime);
        elapsed = elapsed.divide(new BigDecimal("1.0E9"), 5, RoundingMode.HALF_EVEN);
        return elapsed;
    }

    private static final BigDecimal calculateHeapUsed(long nowFreeMemory, BigDecimal startingHeapSize) {
        BigDecimal heapUsed = new BigDecimal(nowFreeMemory + "");
        heapUsed = heapUsed.subtract(startingHeapSize);
        heapUsed = heapUsed.divide(new BigDecimal("1048576.0"), 5, RoundingMode.HALF_EVEN);
        return heapUsed;
    }

    private static final void initListOfCacheTypes() {
        cacheTypes.put(ResultStoreType.SimpleInMemory, new SimpleInMemoryResultStore());
        cacheTypes.put(ResultStoreType.Ehcache, new EhcacheMemoryResultStore());
    }

    public static final class BenchmarkMetric {
        private final operationType operation;
        private final BigDecimal measurement;
        private final unitType unit;

        public BenchmarkMetric(operationType operation, BigDecimal measurement, unitType unit) {
            this.operation = operation;
            this.measurement = measurement;
            this.unit = unit;
        }

        public final String getOperation() {
            return this.operation.toString();
        }

        public final String getUnit() {
            return this.unit.toString();
        }

        public final BigDecimal getMeasurement() {
            return this.measurement;
        }

        public static enum unitType {
            s,
            MB;

        }

        public static enum operationType {
            Put,
            Get,
            Contain,
            Remove;

        }
    }
}

