/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.spin.tools.PKITool;
import org.spin.tools.crypto.CryptoException;

public final class Hashes {
    public static final Algorithm defaultAlgorithm = Algorithm.SHA1;

    private Hashes() {
    }

    public static String sha1(File file) throws CryptoException {
        return Hashes.hash(file, Algorithm.SHA1);
    }

    public static String sha256(File file) throws CryptoException {
        return Hashes.hash(file, Algorithm.SHA256);
    }

    public static String hash(File file) throws CryptoException {
        return Hashes.hash(file, defaultAlgorithm);
    }

    public static String hash(File file, Algorithm algorithm) throws CryptoException {
        try {
            return PKITool.getString(algorithm.hash(new FileReader(file)));
        }
        catch (IOException e) {
            throw new CryptoException("Error reading file to be ahshed: ", e);
        }
    }

    public static String sha1(String text) throws CryptoException {
        return Hashes.hash(text, Algorithm.SHA1);
    }

    public static String sha256(String text) throws CryptoException {
        return Hashes.hash(text, Algorithm.SHA256);
    }

    public static String hash(String text) throws CryptoException {
        return Hashes.hash(text, defaultAlgorithm);
    }

    public static String hash(String text, Algorithm algorithm) throws CryptoException {
        if (text == null) {
            return null;
        }
        return PKITool.getString(algorithm.hash(text.getBytes()));
    }

    public static byte[] sha1(byte[] bytes) throws CryptoException {
        return Algorithm.SHA1.hash(bytes);
    }

    public static byte[] sha256(byte[] bytes) throws CryptoException {
        return Algorithm.SHA256.hash(bytes);
    }

    public static byte[] hash(byte[] bytes) throws CryptoException {
        return defaultAlgorithm.hash(bytes);
    }

    public static byte[] sha1(Reader reader) throws CryptoException {
        return Algorithm.SHA1.hash(reader);
    }

    public static byte[] sha256(Reader reader) throws CryptoException {
        return Algorithm.SHA256.hash(reader);
    }

    public static byte[] hash(Reader reader) throws CryptoException {
        return defaultAlgorithm.hash(reader);
    }

    public static byte[] hash(Reader reader, Algorithm algorithm) throws CryptoException {
        return algorithm.hash(reader);
    }

    public static enum Algorithm {
        SHA1("SHA1"),
        SHA256("SHA-256");

        private final String algorithmName;

        private Algorithm(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        private MessageDigest getMessageDigest() throws CryptoException {
            try {
                return MessageDigest.getInstance(this.getAlgorithmName());
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] hash(byte[] bytes) throws CryptoException {
            MessageDigest hashFunction = this.getMessageDigest();
            try {
                byte[] byArray = hashFunction.digest(bytes);
                return byArray;
            }
            finally {
                hashFunction.reset();
            }
        }

        public byte[] hash(Reader reader) throws CryptoException {
            MessageDigest hashFunction = this.getMessageDigest();
            BufferedReader bufferedReader = new BufferedReader(reader);
            try {
                Object line = bufferedReader.readLine();
                while (line != null) {
                    hashFunction.update(((String)line).getBytes());
                    line = bufferedReader.readLine();
                }
                line = hashFunction.digest();
                return line;
            }
            catch (IOException e) {
                throw new CryptoException(e);
            }
            finally {
                hashFunction.reset();
                try {
                    bufferedReader.close();
                }
                catch (IOException eatenOnPurpose) {}
            }
        }
    }

    public static final class AlgorithmNames {
        public static final String SHA1 = "SHA1";
        public static final String SHA256 = "SHA-256";

        private AlgorithmNames() {
        }
    }
}

