/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;

public final class Environment {
    private static final Logger log = Logger.getLogger(Environment.class);
    private static final Object lock = new Object();
    public static final String SPIN_HOME_UNIX_DEFAULT = ".spin";
    public static final String SPIN_HOME_WIN_DEFAULT = "spin";
    public static final String runtimeProperites = "spinRuntime.properties";
    public static final String keystorePrefix = "spin";
    private static File homeDir;
    private static File confDir;
    private static File pluginDir;
    private static File dbDir;

    private Environment() {
    }

    private static String determineSpinHomeDirectory() throws ConfigException {
        String spinHome = System.getProperty("SPIN_HOME");
        if (spinHome != null) {
            return spinHome;
        }
        spinHome = System.getenv("SPIN_HOME");
        if (spinHome != null) {
            return spinHome;
        }
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new ConfigException("Couldn't determine home directory!");
        }
        return userHome + File.separator + (Environment.isWindows() ? "spin" : SPIN_HOME_UNIX_DEFAULT);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toUpperCase().contains("WINDOWS");
    }

    private static void setDerbyHome() throws ConfigException {
        Environment.setDerbyHome(Environment.getDBDir().toString());
    }

    private static void setDerbyHome(String spinHomeDirectory) {
        System.setProperty("derby.system.home", spinHomeDirectory);
    }

    public static File getHomeDir() throws ConfigException {
        return homeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHomeDir(File userDefinedHomeDir) throws ConfigException {
        if (userDefinedHomeDir == null) {
            throw new IllegalArgumentException("Null home directory base passed in");
        }
        File normalized = Environment.normalize(userDefinedHomeDir);
        Object object = lock;
        synchronized (object) {
            homeDir = normalized;
            Environment.invalidateDerivedDirs();
        }
        log.info((Object)("Now using home dir '" + homeDir + "'"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateDerivedDirs() {
        Object object = lock;
        synchronized (object) {
            confDir = null;
            pluginDir = null;
            dbDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getConfDir() throws ConfigException {
        Object object = lock;
        synchronized (object) {
            if (confDir == null) {
                String spinConfigPath = Environment.getHomeDir() + File.separator + (Object)((Object)SubDirName.conf);
                confDir = new File(spinConfigPath);
                log.info((Object)("Using '" + confDir + "' as Spin config directory"));
            }
            return confDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getPluginDir() throws ConfigException {
        Object object = lock;
        synchronized (object) {
            if (pluginDir == null) {
                String spinPluginPath = Environment.getHomeDir() + File.separator + (Object)((Object)SubDirName.plugins);
                pluginDir = new File(spinPluginPath);
                log.info((Object)("Using '" + pluginDir + "' as Spin plugin directory"));
            }
            return pluginDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getDBDir() throws ConfigException {
        Object object = lock;
        synchronized (object) {
            if (dbDir == null) {
                String spinDBPath = Environment.getHomeDir() + File.separator + (Object)((Object)SubDirName.db);
                dbDir = new File(spinDBPath);
                log.info((Object)("Using '" + dbDir + "' as Spin DB directory"));
            }
            return dbDir;
        }
    }

    private static void makeDirIfNecessary(File dir) throws ConfigException {
        Util.guardNotNull(dir);
        if (!dir.exists()) {
            log.info((Object)("'" + dir + "' doesn't exist."));
            if (!dir.mkdirs()) {
                throw new ConfigException("Couldn't create '" + dir + "'.  Please make it yourself.");
            }
            log.info((Object)("Successfully created '" + dir + "'."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfDir(File pathToConfigDir) throws ConfigException {
        Util.guardNotNull(pathToConfigDir);
        File normalized = Environment.normalize(pathToConfigDir);
        Object object = lock;
        synchronized (object) {
            confDir = normalized;
            log.info((Object)("Config dir is now " + confDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPluginDir(File pathToPluginDir) throws ConfigException {
        Util.guardNotNull(pathToPluginDir);
        File normalized = Environment.normalize(pathToPluginDir);
        Object object = lock;
        synchronized (object) {
            pluginDir = normalized;
            log.info((Object)("Plugin dir is now " + pluginDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDBDir(File pathToDBDir) throws ConfigException {
        Util.guardNotNull(pathToDBDir);
        File normalized = Environment.normalize(pathToDBDir);
        Object object = lock;
        synchronized (object) {
            dbDir = normalized;
            Environment.setDerbyHome(dbDir.toString());
            log.info((Object)("DB dir is now " + dbDir));
        }
    }

    private static File normalize(File file) throws ConfigException {
        Util.guardNotNull(file);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new ConfigException("Couldn't get canonical path to user provided dir '" + file + "'", e);
        }
    }

    static {
        confDir = null;
        pluginDir = null;
        dbDir = null;
        try {
            Environment.setHomeDir(new File(Environment.determineSpinHomeDirectory()));
            Environment.setDerbyHome();
        }
        catch (ConfigException e) {
            throw new RuntimeException("Error locating Spin home directory; this is bad.  Specify it as a JVM system property or environment variable with the name 'SPIN_HOME'. Error: ", e);
        }
        if (Environment.class.getClassLoader().getResourceAsStream("runtime.properties") != null) {
            log.info((Object)"WARNING: Found runtime.properties on the classpath; the new name to use is 'spinRuntime.properties'");
        }
        Properties properties = new Properties();
        try {
            properties.load(Environment.class.getClassLoader().getResourceAsStream(runtimeProperites));
            log.info((Object)"WARNING: Initializaton via spinRuntime.properties is deprecated and WILL BE REMOVED");
        }
        catch (Exception e) {
            log.info((Object)("Error locating runtime.properties: " + e.getMessage()));
        }
        try {
            if (properties.containsKey("absolute")) {
                log.info((Object)("Setting user-defined absolute path for Spin home dir: '" + Environment.normalize(new File(properties.getProperty("absolute"))) + "'"));
                Environment.setHomeDir(new File(properties.getProperty("absolute")));
            } else if (confDir != null) {
                log.info((Object)("STATIC CONEXT REINITIALIZED? absolute path is already " + Environment.getHomeDir()));
            }
        }
        catch (ConfigException e) {
            System.err.println("Error determining absolute path of Spin config directory: " + e.getMessage());
        }
    }

    public static enum SubDirName {
        conf,
        plugins,
        db;

    }

    public static final class PropertyKeys {
        public static final String spinHome = "SPIN_HOME";
        public static final String userHome = "user.home";
        public static final String derbyHome = "derby.system.home";
        public static final String absolute = "absolute";

        private PropertyKeys() {
        }
    }
}

