/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import org.spin.tools.config.ConfigTool;

public final class ImportKey {
    private ImportKey() {
    }

    private static InputStream fullStream(String fname) throws IOException {
        FileInputStream fis = new FileInputStream(fname);
        DataInputStream dis = new DataInputStream(fis);
        byte[] bytes = new byte[dis.available()];
        dis.readFully(bytes);
        return new ByteArrayInputStream(bytes);
    }

    public static void main(String[] args) {
        String keypass = "spinkeystore";
        String keystorename = "spin.keystore";
        String defaultalias = ConfigTool.getHostName();
        String keyfile = "";
        String certfile = "";
        if (args.length < 2 || args.length > 3) {
            System.out.println("Usage: java org.spin.tools.ImportKey keyfile certfile [alias]");
            System.exit(0);
        } else {
            keyfile = args[0];
            certfile = args[1];
            if (args.length > 2) {
                defaultalias = args[2];
            }
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS", "SUN");
            ks.load(null, "spinkeystore".toCharArray());
            System.out.println("Using keystore-file : " + new File("spin.keystore").getAbsolutePath());
            System.out.println("Using key-file : " + new File(keyfile).getAbsolutePath());
            System.out.println("Using cert-file : " + new File(certfile).getAbsolutePath());
            ks.store(new FileOutputStream("spin.keystore"), "spinkeystore".toCharArray());
            ks.load(new FileInputStream("spin.keystore"), "spinkeystore".toCharArray());
            InputStream fl = ImportKey.fullStream(keyfile);
            byte[] key = new byte[fl.available()];
            KeyFactory kf = KeyFactory.getInstance("RSA");
            fl.read(key, 0, fl.available());
            fl.close();
            PKCS8EncodedKeySpec keysp = new PKCS8EncodedKeySpec(key);
            PrivateKey ff = kf.generatePrivate(keysp);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream certstream = ImportKey.fullStream(certfile);
            Collection<? extends Certificate> c = cf.generateCertificates(certstream);
            Certificate[] certs = new Certificate[c.toArray().length];
            if (c.size() == 1) {
                Certificate cert;
                certstream = ImportKey.fullStream(certfile);
                System.out.println("One certificate, no chain.");
                certs[0] = cert = cf.generateCertificate(certstream);
            } else {
                System.out.println("Certificate chain length: " + c.size());
                certs = c.toArray(new Certificate[c.size()]);
            }
            ks.setKeyEntry(defaultalias, ff, "spinkeystore".toCharArray(), certs);
            System.out.println("Key and certificate stored.");
            System.out.println("Alias:" + defaultalias + "  Password:" + "spinkeystore");
            ks.store(new FileOutputStream("spin.keystore"), "spinkeystore".toCharArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

