/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.integration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.shrine.integration.util.LogUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.spin.tools.JAXBUtils;

public class JAXBServlet
extends HttpServlet {
    private static final long serialVersionUID = -6604027882440087387L;
    static final Logger LOGGER = LogUtil.createLogger((Level)Level.ALL);
    public static final boolean DEBUG = LOGGER.isDebugEnabled();
    public static final boolean INFO = LOGGER.isInfoEnabled();
    static final String CLASSNAME_KEY = "classname";
    static final String XSLT_PATH_KEY = "xsl";
    static final String TRANSFORM_EXTERNALLY_KEY = "transformExternally";
    static final String XSLT_TEMPLATE = "<?xml-stylesheet type=\"text/xsl\" href=\"%s\"?>\n";
    private Class<?> classValue = null;
    private String xlstPathValue = null;
    private Boolean transformExternally = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String classNameValue = config.getInitParameter(CLASSNAME_KEY);
        try {
            this.classValue = Class.forName(classNameValue);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(String.format("could not locate class : %s ", classNameValue), (Throwable)e);
        }
        this.xlstPathValue = config.getInitParameter(XSLT_PATH_KEY);
        assert (this.xlstPathValue != null) : String.format("failed to locate servlet parameter %s : %s", "xsl", this.xlstPathValue);
        this.transformExternally = Boolean.parseBoolean(config.getInitParameter(TRANSFORM_EXTERNALLY_KEY));
        LOGGER.log((Priority)Level.INFO, (Object)String.format("classvalue : %s ", this.classValue));
        LOGGER.log((Priority)Level.INFO, (Object)String.format("xlstPathValue : %s ", this.xlstPathValue));
        LOGGER.log((Priority)Level.INFO, (Object)String.format("transformExternally : %s ", this.transformExternally));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Object object = this.classValue.newInstance();
            Marshaller marshaller = JAXBUtils.getMarshaller((Class[])new Class[]{this.classValue});
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            String buffer = JAXBUtils.marshalToString(object);
            response.setContentType(this.transformExternally != false ? "text/xml" : "text/html");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream());
            if (this.xlstPathValue != null) {
                out.write(String.format(XSLT_TEMPLATE, request.getContextPath() + this.xlstPathValue));
            }
            if (this.transformExternally.booleanValue()) {
                out.write(buffer);
            } else {
                InputStream inputStream = this.getServletContext().getResourceAsStream(this.xlstPathValue);
                System.err.println("XXX : inputStream : " + inputStream);
                StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(buffer.getBytes()));
                StreamSource xltSource = new StreamSource(inputStream);
                StreamResult outputTarget = new StreamResult(out);
                Transformer transformer = TransformerFactory.newInstance().newTransformer(xltSource);
                transformer.transform(xmlSource, outputTarget);
            }
            out.flush();
            out.close();
        }
        catch (InstantiationException e) {
            throw new ServletException(String.format("failed creating class : %s ", this.classValue), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException(String.format("failed creating class : %s ", this.classValue), (Throwable)e);
        }
        catch (JAXBException e) {
            throw new ServletException(String.format("failed marshalling class : %s ", this.classValue), (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new ServletException(String.format("failed loading transformer on : %s ", this.xlstPathValue), (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ServletException(String.format("failed loading transformer on : %s ", this.xlstPathValue), (Throwable)e);
        }
        catch (TransformerException e) {
            throw new ServletException(String.format("failed loading transformer on : %s ", this.xlstPathValue), (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

