/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.integration.reports;

import net.shrine.config.ShrineConfig;
import net.shrine.integration.ReportDTO;
import net.shrine.integration.util.LogUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ShrineConfigReport
extends ReportDTO {
    private static final Logger LOGGER = LogUtil.createLogger();

    public ShrineConfigReport(ShrineConfig shrineConfig) {
        super("Shrine Config ");
        ReportDTO.EntryDTO broadCastEntry = this.pack("Is broadcast enabled?");
        ReportDTO.EntryDTO authenticatedExpireEntry = this.pack("Authenticated identities Expire In (ms)");
        ReportDTO.EntryDTO cachedQueriesExpireEntry = this.pack("Cached Queries Expire In (ms)");
        ReportDTO.EntryDTO maxTimeToWait = this.pack("Max Time to Wait for Query Completion (ms)");
        ReportDTO.EntryDTO lockoutAttemptsThreshold = this.pack("Number of Repeated Query for Lockout");
        ReportDTO.EntryDTO explictMapping = this.pack("Adapter Requires Explicit Mappings");
        try {
            broadCastEntry.setValue(this.nvl((Object)shrineConfig.isBroadcasterAggregator()));
            authenticatedExpireEntry.setValue(this.nvl((Object)shrineConfig.getCertificationTTL()));
            cachedQueriesExpireEntry.setValue(this.nvl((Object)shrineConfig.getCacheTTL()));
            maxTimeToWait.setValue(this.nvl((Object)shrineConfig.getQueryTTL()));
            lockoutAttemptsThreshold.setValue(this.nvl((Object)shrineConfig.getAdapterLockoutAttemptsThreshold()));
            explictMapping.setValue(this.nvl((Object)shrineConfig.isAdapterRequireExplicitMappings()));
        }
        catch (Exception e) {
            LOGGER.log((Priority)Level.ERROR, (Object)"generate shrine config", (Throwable)e);
            this.exception = e.getMessage();
        }
    }
}

