package org.eaglei.feedback;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;

import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import org.harvard.hms.cbmi.jira.SOAPClient;

public class FeedbackBean implements Serializable {
	
	private static String jiraProjectKey="FBK";
	private static String jiraComponentId_Alaska="10220";
	private static String jiraComponentId_Dartmouth="10221";
	private static String jiraComponentId_Harvard="10222";
	private static String jiraComponentId_Hawaii="10223";
	private static String jiraComponentId_JSU="10224";
	private static String jiraComponentId_Montana="10225";
	private static String jiraComponentId_MSM="10226";
	private static String jiraComponentId_OHSU="10227";
	private static String jiraComponentId_UPR="10228";
	
	private static String jiraUsr="webform_user";
	private static String jiraPwd="Zarsten8896";
	
	private static String jiraURL="http://jira.eagle-i.net:8080/rpc/soap/jirasoapservice-v2";
	
	private String summary = "";
	private String description = "";
	private String institution = "";
	private String url = null;
	private String agent = null;
	private String name = null;
	private String email = null;
	private String phone = null;
	private String question = null;
	private Boolean emailOptIn = null;
	private RemoteIssue issue=null;
	private String errorMsg=null;
	
	public void setSummary(String aString){
		summary=aString;
	}
	public String getSummary(){
		return summary;
	}
	
	public void setDescription(String aString){
		description=aString;
	}
	public String getDescription(){
		return description;
	}
	
	public void setIssue(RemoteIssue ri){
		issue = ri;
	}
	public RemoteIssue getIssue(){
		return issue;
	}
	
	public String getIssueKey() {
		if (issue == null) return null;
		return issue.getKey();
	}
	
	public String getErrorMsg(){
		return errorMsg;
	}
	public void setErrorMsg(String msg){
		errorMsg=msg;
	}
	
	public Boolean getEmailOptIn() {
		if (emailOptIn == null){
			return Boolean.FALSE;
		}
		return emailOptIn;
	}
	public void setEmailOptIn(Boolean value) {
		emailOptIn=value;
	}

	
	private String getHeader(){
		String header="url: ";
		if (url != null){
			header=header + url;
		} else {
			header=header + "\"no url defined\"";
		}
		header=header + "\nuser agent: ";
		if (name != null){
			header=header + agent;
		} else {
			header=header + "\"no user agent provided\"";
		}
		header=header + "\nname: ";
		if (name != null){
			header=header + name;
		} else {
			header=header + "\"no user name provided\"";
		}
		header=header + "\nemail: ";
		if (email != null){
			header=header + email;
		} else {
			header=header + "\"no email address provided\"";
		}
		header=header + "\nphone: ";
		if (phone != null){
			header=header + phone;
		} else {
			header=header + "\"no phone number provided\"";
		}
		header=header + "\nquestion: ";
		if (question != null){
			header=header + question;
		} else {
			header=header + "\"no question subject provided\"";
		}
		header=header + "\nemail notifications requested: ";
		if (getEmailOptIn()){
			header=header + "yes";
		} else {
			header=header + "no";
		}
		return (header+"\n\n");
	}
	
	private String getEnhancedDescription(){
		return getHeader() + getDescription();
	}

	public void setUrl(String aString){
		url=aString;
	}
	public String getUrl(){
		return url;
	}
	
	public void setAgent(String aString){
		agent=aString;
	}
	public String getAgent(){
		return agent;
	}
	
	public void setName(String aString){
		name=aString;
	}
	public String getName(){
		return name;
	}
	public void setEmail(String aString){
		email=aString;
	}
	public String getEmail(){
		return email;
	}
	public void setPhone(String aString){
		phone=aString;
	}
	public String getPhone(){
		return phone;
	}
	public void setQuestion(String aString){
		question=aString;
	}
	public String getQuestion(){
		return question;
	}
	
	public void setInstitution(String aString){
		institution=aString;
	}
	public String getInstitution(){
		return institution;
	}
	
	public boolean createIssue(){
		SOAPClient soapClient= new SOAPClient(jiraURL, jiraUsr, jiraPwd);
		try {
			setIssue(soapClient.createIssue(jiraProjectKey, getInstitution(), getSummary(), getEnhancedDescription()));
			return true;
		} catch (RemoteException rx){
			setErrorMsg(rx.getMessage());
			rx.printStackTrace();
			return false;
		}
	}
	

}
