/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.jena.JenaEIOntModel;

public class NonResourceVisitor
implements EIOntModel.Visitor {
    protected static final Log logger = LogFactory.getLog(NonResourceVisitor.class);
    private JenaEIOntModel model;
    public Set<EIClass> setNonResource;
    int count;

    public NonResourceVisitor(JenaEIOntModel model) {
        this.model = model;
        this.setNonResource = new HashSet<EIClass>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String traversalComplete() {
        Iterator<EIClass> i$;
        OutputStreamWriter fw = null;
        try {
            logger.info((Object)("Writing non-resource class file.  Num classes: " + this.setNonResource.size()));
            File dir = NonResourceVisitor.ensureOutputDirectory("target/output");
            File f = new File(dir, "rootNonResourceList.txt");
            if (f.exists() && !f.delete()) {
                String string = "Unable to delete: " + f.getAbsolutePath();
                return string;
            }
            fw = new FileWriter(f);
            for (EIClass c : this.setNonResource) {
                logger.info((Object)("  " + c.getEntity()));
                fw.write(c.getEntity().getURI().toString());
                fw.write(44);
            }
            i$ = null;
        }
        catch (IOException e) {
            logger.error((Object)e);
            String string = e.getMessage();
            return string;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {}
            }
        }
        return i$;
    }

    public void visit(EIClass c) {
        if (this.count % 20 == 0) {
            logger.info((Object)(this.count + " classes have been checked.  non-resource classes: " + this.setNonResource.size()));
        }
        ++this.count;
        if (!c.isEagleIResource()) {
            this.addNonResourceClass(c);
        }
    }

    public void visit(EIProperty p) {
    }

    private void addNonResourceClass(EIClass c) {
        HashSet<EIClass> remove = new HashSet<EIClass>();
        OntClass ontClass = this.model.getOntologyClass(c.getEntity().getURI().toString());
        for (EIClass member : this.setNonResource) {
            OntClass memberOntClass = this.model.getOntologyClass(member.getEntity().getURI().toString());
            if (memberOntClass.hasSubClass((Resource)ontClass)) {
                return;
            }
            if (!ontClass.hasSubClass((Resource)memberOntClass)) continue;
            remove.add(member);
            logger.debug((Object)(c.getEntity().getLabel() + ":  addNonResourceClass: REMOVED:" + member.getEntity().getLabel()));
        }
        this.setNonResource.removeAll(remove);
        this.setNonResource.add(c);
        logger.debug((Object)(c.getEntity().getLabel() + ":  addNonResourceClass: ADDED:"));
    }

    public static File ensureOutputDirectory(String outputPath) throws IOException {
        if (outputPath == null || outputPath.length() == 0) {
            logger.error((Object)"Empty or null output path");
            return null;
        }
        File outputDir = new File(outputPath);
        logger.info((Object)("Generating test data to directory: " + outputDir.getAbsolutePath()));
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            logger.error((Object)("Failed to create output directory " + outputDir.getAbsolutePath()));
            return null;
        }
        return outputDir;
    }
}

