package org.eaglei.suggest.client;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SuggestOracle.Suggestion;

public class SharedClassChooser<OntologyPicker extends OntologyDropdownBase> extends Composite implements HasSelectionHandlers<EIEntity> {
	private static class TypeSuggestOracle extends SearchSuggestOracle {
        private String classId;

        public TypeSuggestOracle() {
            super(GWT.getModuleBaseURL());
        }

        void setClassId(EIURI classId) {
            this.classId = URL.encodeComponent(classId.toString());
        }

        protected String createURL(String callbackName, int id, String query) {
            String url = super.createURL(callbackName, id, query);
            return url + "&classid=" + classId;
        }
    }

    /**/

    /**/
    private static class TypeSuggestBox extends AbstractSearchBox implements HasSelectionHandlers<EIEntity> {
        private EIClass resource;
        private EIEntity selectedEntity;

        public TypeSuggestBox() {
            super(new TypeSuggestOracle(), "TypeSearchBox");
            sbSearch.getTextBox().addBlurHandler(new BlurHandler() {

                @Override
                public void onBlur(BlurEvent event) {
                    if (! selectedEntity.getLabel().equals(sbSearch.getText())) {
                        if (selectedEntity.equals(resource.getEntity())) {
                            setDefaultText();
                        } else {
                            sbSearch.setText(selectedEntity.getLabel());
                        }
                    }
                }
                
            });
        }

        @Override
        public String getDefaultText() {
            return resource != null ? resource.getEntity().getLabel() : "";
        }

        @Override
        public String getSearchBaseURL() {
            assert (false);
            return null;
        }

        public void setResource(EIClass resource) {
        	this.resource = resource;
            this.selectedEntity = resource.getEntity();
            ((TypeSuggestOracle) sbSearch.getSuggestOracle()).setClassId(resource.getEntity()
                    .getURI());
            setDefaultText();
        }

        public EIEntity getSelectedEntity() {
            return selectedEntity;
        }

        public void setSelectedEntity(EIEntity selectedEntity) {
        	this.selectedEntity = selectedEntity;
            setText(selectedEntity.getLabel());
            SelectionEvent.fire(this, selectedEntity);
        }

		@Override
		public HandlerRegistration addSelectionHandler(
				SelectionHandler<EIEntity> handler) {
			return null;
		}

    }

    /**/

    private TypeSuggestBox boxType;
    private OntologyPicker ontologyBrowser;

    public SharedClassChooser(OntologyPicker ontPicker) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        initWidget(hp);

        boxType = new TypeSuggestBox();
        boxType.addSelectionHandler(new SelectionHandler<Suggestion>() {
            public void onSelection(SelectionEvent<Suggestion> event) {
                SearchSuggestion suggestion = (SearchSuggestion) event.getSelectedItem();
                // This is a bit sketchy as the suggest list display string
                // may not technically match the preferred entity label.
                EIEntity selectedEntity = 
                    EIEntity.create(suggestion.getURIString(), removeTags(suggestion.getDisplayString()));
                boxType.setSelectedEntity(selectedEntity);
            }
        });
        hp.add(boxType);

        ontologyBrowser = ontPicker;
        ontologyBrowser.addSelectionListener(new SelectionListener() {

            public void onSelection(EIClass resource) {
                boxType.setSelectedEntity(resource.getEntity());
            }

        });
        hp.add(ontologyBrowser);
    }
    
    // TODO: test me!
    protected String removeTags(String displayString) {
		String result = displayString.replace("<B>", "");
		result = result.replace("</B>", "");
				
		return result;
	}

    public void setClass(EIClass rClass, boolean readOnly) {
        boxType.setResource(rClass);
        // if (readOnly) {
        // boxType.setText(rClass.getEntity().getLabel());
        // }
        // boxType.setReadOnly(readOnly);
        if (rClass.hasSubClass()) {
            ontologyBrowser.setResource(rClass);
            ontologyBrowser.setVisible(true);
        } else {
            ontologyBrowser.setVisible(false);
        }
    }

    public EIURI getSelectedURI() {
        return boxType.getSelectedEntity().getURI();
    }
    
    public void setTextBoxStyle(String styleName)
    {
    	boxType.setStyleName(styleName);
    }

	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<EIEntity> handler) {
		boxType.addSelectionHandler(handler);
		return null;
	}
}
