package org.eaglei.suggest.provider;

/**
 * Represents an auto-suggestion. Class structure is aligned with the GWT Suggestion class.
 * 
 * @author rfrost
 */
public class Suggestion {

	// string that gets put in the text box on select, no html
    private String replacementText;
    // the display text, can include html
    private String displayText;
    // the entity uri
    private String uri;  
    
    public Suggestion(final String displayText, final String replacementText, final String uri) {
        this.displayText = displayText;
        this.replacementText = replacementText;
        this.uri = uri;
    }
    
    public String getDisplayText() {
        return this.displayText;
    }
    
    public String getURI() {
        return this.uri;
    }
    
    public String getReplacementText() {
        return this.replacementText;
    }
    
    @Override
    public int hashCode() {
        return replacementText.hashCode();
    }
    
    @Override
    public boolean equals(Object other) {
        if (! (other instanceof Suggestion)) {
            return false;
        }
        return ((Suggestion) other).replacementText.equals(replacementText);
    }
    
    @Override
    public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(displayText);
    	sb.append(" (");
    	sb.append(replacementText);
    	sb.append(", ");
    	sb.append(uri);    	
    	sb.append(")");    	
    	return sb.toString();
    }
}

