package org.eaglei.suggest.provider.lucene;

import java.io.Reader;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/**
 * Subclass of Lucene's Analyzer that supports the KeywordTokenizer for auto-suggest.
 */
public class AutoSuggestQueryAnalyzer extends Analyzer {
    
    /**
     * Creates a new KeywordAnalyzer.
     */
    public AutoSuggestQueryAnalyzer() {
    }

    @Override
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        //Tokenizer tokenStream = new KeywordTokenizer(reader);   
        Tokenizer tokenStream = new StandardTokenizer(Version.LUCENE_30, reader);   
        TokenStream result = new StandardFilter(tokenStream);        
        result = new LowerCaseFilter(result);
        return result;
    };
}
