package org.eaglei.suggest.provider.model.poc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.suggest.provider.Suggestion;
import org.eaglei.suggest.provider.SuggestionProvider;
import org.eaglei.suggest.provider.SuggestionSource;
import org.eaglei.suggest.provider.model.lucene.ModelSuggestionSource;

/**
 * Old custom suggestion implementation
 * 
 * @author tbashor Original implementation embedded in SuggestionServlet
 * @author rfrost Moved into separate SuggestionProvider (not fully enabled)
 */
public final class POCModelSuggestionProvider implements SuggestionProvider {
	
	
	// char to list of lower to display string
    // the list is the token index 
    // For example, "DNA Sequencer" will be indexed twice, in the
    // "d" list in its first map, in the "s" map in its second map.
    private Map<Character, List<Set<SuggestItem>>> suggestIndex = 
        new HashMap<Character, List<Set<SuggestItem>>>();

    private List<String> uris;
    
    public POCModelSuggestionProvider(final String uri) {
    	this(Collections.singletonList(uri));
	}
	
	public POCModelSuggestionProvider(final List<String> uris) {
		this.uris = uris;
	}
    
    /**
     * Initializes the auto-suggest index.
     * @throws IOException Thrown if an error is encountered creating the index.
     */
    public void index(final SuggestionSource source) throws IOException {
    	// ignore the source in this case - will always be the eagle-i ontology
    	// retrieved via JenaEIOntModel.INSTANCE
    	for (String uri: uris) {
    		EIClass c = JenaEIOntModel.INSTANCE.getClass(EIURI.create(uri));
    		indexClass(c);
    	}
    	indexingComplete();
    }

	/*
     * Recursively descend the class tree
     * adding the class label to both the main index and the 
     * and the given index.
     */
    private void indexClass(EIClass c) {
        List<EIEntity> listTypeLabels = JenaEIOntModel.INSTANCE.getTypeEntities(c.getEntity().getURI());
        for (EIEntity e : listTypeLabels) {
            add(e);
        }
    }
    
    public List<Suggestion> getSuggestions(String query, int maxSuggestions) throws IOException {
    	return null;
    	// XXX need to port over SuggestItem to Suggestion
    	/*
    	List<SuggestItem> suggestions = new ArrayList<SuggestItem>(limit);
        // All names that have a token starting with same character as the
        // request
        // TODO deal with request strings that contain a space
        query = query.toLowerCase();
        List<Set<SuggestItem>> tokenSetList = suggestIndex.get(query.charAt(0));
        for (int tokenIndex = 0; suggestions.size() < limit && tokenIndex < tokenSetList.size(); tokenIndex++) {
            Set<SuggestItem> tokenSet = tokenSetList.get(tokenIndex);
            for (SuggestItem item : tokenSet) {
                if (item.endSeg.startsWith(query)) {
                    suggestions.add(item);
                    if (suggestions.size() == limit) {
                        break;
                    }
                }
            }
        }
        return suggestions;
        */
    }
    
    private void add(EIEntity entity) {
        String lower = entity.getLabel().trim().toLowerCase();
        String strURI = entity.getURI().toString();
        // tokenize the entity label, generate a SuggestItem for each token
        List<SuggestItem> tokens = new ArrayList<SuggestItem>();
        tokens.add(new SuggestItem(lower, strURI, 0));
        boolean inSpace = false;
        for (int charIndex=0; charIndex<lower.length(); charIndex++) {
            if (lower.charAt(charIndex) == ' ') {
                // assuming there are no other whitespace chars...
                inSpace = true;
            } else if (inSpace) {
                // We've just come out of space, make a token
                tokens.add(new SuggestItem(lower, strURI, charIndex));
                inSpace = false;
            }
        }
        for (int tokenIndex=0; tokenIndex<tokens.size(); tokenIndex++) {
            SuggestItem token = tokens.get(tokenIndex);
	        Character startsWith = token.endSeg.charAt(0);
	        List<Set<SuggestItem>> tokenSetList = suggestIndex.get(startsWith);
	        // Ensure the token list exist
	        if (tokenSetList == null) {
	            tokenSetList = new ArrayList<Set<SuggestItem>>();
	            suggestIndex.put(startsWith, tokenSetList);
	        }
	        // Size the list to the token index
	        Set<SuggestItem> tokenSet = null;
            for (int j=tokenSetList.size(); j<=tokenIndex; j++) {
                tokenSet = new TreeSet<SuggestItem>();
                tokenSetList.add(tokenSet);
            }
            //
	        if (tokenSet == null) {
	            tokenSet = tokenSetList.get(tokenIndex);
	        }
	        tokenSet.add(token);
        }
    }
    
    public void indexingComplete() {
        // opportunity to optimize our index data structures
    }
    
    // Data structure used to optimize generation of
    // html suggest strings
    private static class SuggestItem implements Comparable<SuggestItem> {
        String text;  // string that gets put in the text box on select, no html
        String startSeg;  // first segment of html display string, ends with <b>
        String endSeg;  // the first chars of this segment are will be use for matching
        String uri;  // the entity uri
        
        SuggestItem(String text, String strURI, int startIndex) {
            this.text = text;
            this.startSeg = text.substring(0, startIndex) + "<b>";
            this.endSeg = text.substring(startIndex);
            this.uri = strURI;
        }
        
        @Override
        public int hashCode() {
            return text.hashCode();
        }
        
        @Override
        public boolean equals(Object other) {
            if (! (other instanceof SuggestItem)) {
                return false;
            }
            return ((SuggestItem) other).text.equals(text);
        }

        @Override
        public int compareTo(SuggestItem o) {
            // Sort first by the end segment.
            // if end segments are same, sort by full label
            int result = endSeg.compareTo(o.endSeg);
            return (result != 0) ? result : text.compareTo(o.text);
        }
    }
    
}
