/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.client;

import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.suggest.client.SearchSuggestOracle;
import org.eaglei.suggest.client.SearchSuggestion;

public abstract class AbstractSearchBox
extends Composite {
    private SearchHandler handler = null;
    private SearchCommand searchCommand;
    protected final SuggestBox sbSearch;

    public AbstractSearchBox(String suggestBaseURL, String style) {
        this(new SearchSuggestOracle(suggestBaseURL), style);
    }

    public AbstractSearchBox(SearchSuggestOracle oracle, String style) {
        this.sbSearch = new SuggestBox((SuggestOracle)oracle);
        this.sbSearch.setStyleName(style);
        this.sbSearch.setAutoSelectEnabled(false);
        this.sbSearch.setPopupStyleName("SearchBoxPopup");
        this.sbSearch.getTextBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (AbstractSearchBox.this.getDefaultText().equals(AbstractSearchBox.this.sbSearch.getText())) {
                    AbstractSearchBox.this.setText("");
                }
            }
        });
        this.initWidget((Widget)this.sbSearch);
    }

    public SearchHandler getSearchHandler() {
        return this.handler;
    }

    public void addSelectionHandler(SelectionHandler<SuggestOracle.Suggestion> handler) {
        this.sbSearch.addSelectionHandler(handler);
    }

    public void addSearchHandler(SearchHandler handler, boolean notifyOnListSelect, boolean notifyOnEnter) {
        this.handler = handler;
        if (handler == null) {
            this.searchCommand = null;
            return;
        }
        this.searchCommand = new SearchCommand();
        if (notifyOnListSelect) {
            this.sbSearch.addSelectionHandler((SelectionHandler)new SelectionHandler<SuggestOracle.Suggestion>(){

                public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                    SearchSuggestion suggestion = (SearchSuggestion)event.getSelectedItem();
                    String strSuggestQuery = suggestion.getReplacementString();
                    AbstractSearchBox.this.searchCommand.setSuggestQuery(strSuggestQuery);
                    DeferredCommand.addCommand((Command)AbstractSearchBox.this.searchCommand);
                }
            });
        }
        if (notifyOnEnter) {
            this.sbSearch.getTextBox().addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    if (event.getNativeKeyCode() == 13) {
                        String query = AbstractSearchBox.this.sbSearch.getText();
                        AbstractSearchBox.this.searchCommand.setTextQuery(query);
                        DeferredCommand.addCommand((Command)AbstractSearchBox.this.searchCommand);
                    }
                }
            });
        }
    }

    public abstract String getDefaultText();

    public abstract String getSearchBaseURL();

    public String getText() {
        String query = this.sbSearch.getText().trim();
        if (this.getDefaultText().equals(query)) {
            return "";
        }
        return query;
    }

    public void setDefaultText() {
        this.sbSearch.setText(this.getDefaultText());
        this.sbSearch.addStyleDependentName("default");
    }

    public void setText(String text) {
        this.sbSearch.setText(text);
        this.sbSearch.removeStyleDependentName("default");
    }

    class SearchCommand
    implements Command {
        private String queryText;
        private String querySuggest;

        SearchCommand() {
        }

        public void execute() {
            if (this.querySuggest != null) {
                this.handleSearchSelected(this.querySuggest);
            } else if (this.queryText != null) {
                this.handleSearchSelected(this.queryText);
            }
            this.queryText = null;
            this.querySuggest = null;
        }

        public void setTextQuery(String queryText) {
            this.queryText = queryText.trim();
        }

        public void setSuggestQuery(String queryText) {
            this.queryText = queryText;
        }

        private void handleSearchSelected(String query) {
            if (query == null || query.length() == 0) {
                return;
            }
            AbstractSearchBox.this.handler.performSearch(query);
        }
    }

    public static interface SearchHandler {
        public void performSearch(String var1);
    }
}

