/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.AbstractSearchBox;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SearchSuggestOracle;
import org.eaglei.suggest.client.SearchSuggestion;
import org.eaglei.suggest.client.SelectionListener;

public class SharedClassChooser<OntologyPicker extends OntologyDropdownBase>
extends Composite
implements HasSelectionHandlers<EIEntity> {
    private TypeSuggestBox boxType;
    private OntologyPicker ontologyBrowser;

    public SharedClassChooser(OntologyPicker ontPicker) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.initWidget((Widget)hp);
        this.boxType = new TypeSuggestBox();
        this.boxType.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                SearchSuggestion suggestion = (SearchSuggestion)event.getSelectedItem();
                EIEntity selectedEntity = EIEntity.create((String)suggestion.getURIString(), (String)SharedClassChooser.this.removeTags(suggestion.getDisplayString()));
                SharedClassChooser.this.boxType.setSelectedEntity(selectedEntity);
            }
        });
        hp.add((Widget)this.boxType);
        this.ontologyBrowser = ontPicker;
        ((OntologyDropdownBase)((Object)this.ontologyBrowser)).addSelectionListener(new SelectionListener(){

            @Override
            public void onSelection(EIClass resource) {
                SharedClassChooser.this.boxType.setSelectedEntity(resource.getEntity());
            }
        });
        hp.add(this.ontologyBrowser);
    }

    protected String removeTags(String displayString) {
        String result = displayString.replace("<B>", "");
        result = result.replace("</B>", "");
        return result;
    }

    public void setClass(EIClass rClass, boolean readOnly) {
        this.boxType.setResource(rClass);
        if (rClass.hasSubClass()) {
            ((OntologyDropdownBase)((Object)this.ontologyBrowser)).setResource(rClass);
            this.ontologyBrowser.setVisible(true);
        } else {
            this.ontologyBrowser.setVisible(false);
        }
    }

    public EIURI getSelectedURI() {
        return this.boxType.getSelectedEntity().getURI();
    }

    public void setTextBoxStyle(String styleName) {
        this.boxType.setStyleName(styleName);
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<EIEntity> handler) {
        this.boxType.addSelectionHandler(handler);
        return null;
    }

    private static class TypeSuggestBox
    extends AbstractSearchBox
    implements HasSelectionHandlers<EIEntity> {
        private EIClass resource;
        private EIEntity selectedEntity;

        public TypeSuggestBox() {
            super(new TypeSuggestOracle(), "TypeSearchBox");
            this.sbSearch.getTextBox().addBlurHandler(new BlurHandler(){

                public void onBlur(BlurEvent event) {
                    if (!TypeSuggestBox.this.selectedEntity.getLabel().equals(TypeSuggestBox.this.sbSearch.getText())) {
                        if (TypeSuggestBox.this.selectedEntity.equals((Object)TypeSuggestBox.this.resource.getEntity())) {
                            TypeSuggestBox.this.setDefaultText();
                        } else {
                            TypeSuggestBox.this.sbSearch.setText(TypeSuggestBox.this.selectedEntity.getLabel());
                        }
                    }
                }
            });
        }

        @Override
        public String getDefaultText() {
            return this.resource != null ? this.resource.getEntity().getLabel() : "";
        }

        @Override
        public String getSearchBaseURL() {
            assert (false);
            return null;
        }

        public void setResource(EIClass resource) {
            this.resource = resource;
            this.selectedEntity = resource.getEntity();
            ((TypeSuggestOracle)this.sbSearch.getSuggestOracle()).setClassId(resource.getEntity().getURI());
            this.setDefaultText();
        }

        public EIEntity getSelectedEntity() {
            return this.selectedEntity;
        }

        public void setSelectedEntity(EIEntity selectedEntity) {
            this.selectedEntity = selectedEntity;
            this.setText(selectedEntity.getLabel());
            SelectionEvent.fire((HasSelectionHandlers)this, (Object)selectedEntity);
        }

        public HandlerRegistration addSelectionHandler(SelectionHandler<EIEntity> handler) {
            return null;
        }
    }

    private static class TypeSuggestOracle
    extends SearchSuggestOracle {
        private String classId;

        public TypeSuggestOracle() {
            super(GWT.getModuleBaseURL());
        }

        void setClassId(EIURI classId) {
            this.classId = URL.encodeComponent((String)classId.toString());
        }

        @Override
        protected String createURL(String callbackName, int id, String query) {
            String url = super.createURL(callbackName, id, query);
            return url + "&classid=" + this.classId;
        }
    }
}

