/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.provider.model.lucene;

import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.common.lexical.model.EIModelEntityExtractorFactory;
import org.eaglei.common.lexical.model.ModelEntitySource;
import org.eaglei.suggest.provider.SuggestionProvider;
import org.eaglei.suggest.provider.model.lucene.ModelSuggestionProvider;
import org.eaglei.suggest.provider.model.lucene.ModelSuggestionSource;

public final class EIModelSuggestionProviderFactory {
    private static final List<String> props = new ArrayList<String>();

    public static Map<String, SuggestionProvider> createProviderForEachTopLevel() throws IOException {
        HashMap<String, SuggestionProvider> idToProvider = new HashMap<String, SuggestionProvider>();
        Map uriToSource = EIModelEntityExtractorFactory.createSourcesForEachTopLevel();
        for (String uri : uriToSource.keySet()) {
            ModelSuggestionSource source = new ModelSuggestionSource((ModelEntitySource)uriToSource.get(uri));
            ModelSuggestionProvider provider = new ModelSuggestionProvider();
            provider.index(source);
            idToProvider.put(uri, provider);
        }
        return idToProvider;
    }

    public static SuggestionProvider createProviderForAllRoots() throws IOException {
        ModelSuggestionSource source = new ModelSuggestionSource(EIModelEntityExtractorFactory.createSourceForAllRoots());
        ModelSuggestionProvider provider = new ModelSuggestionProvider();
        provider.index(source);
        return provider;
    }

    static {
        props.add(RDFS.label.getURI());
        props.add("http://purl.obolibrary.org/obo/IAO_0000111");
        props.add("http://purl.obolibrary.org/obo/IAO_0000118");
    }
}

