/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.provider.model.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.eaglei.common.lexical.EntityMatch;
import org.eaglei.common.lexical.model.ModelEntityExtractor;
import org.eaglei.suggest.provider.Suggestion;
import org.eaglei.suggest.provider.SuggestionProvider;
import org.eaglei.suggest.provider.SuggestionSource;
import org.eaglei.suggest.provider.lucene.AutoSuggestIndexAnalyzer;
import org.eaglei.suggest.provider.lucene.AutoSuggestQueryAnalyzer;
import org.eaglei.suggest.provider.model.lucene.ModelSuggestionSource;

public class ModelSuggestionProvider
implements SuggestionProvider {
    private ModelEntityExtractor extractor;

    @Override
    public void index(SuggestionSource source) throws IOException {
        assert (source != null);
        assert (source instanceof ModelSuggestionSource);
        ModelSuggestionSource modelSource = (ModelSuggestionSource)source;
        AutoSuggestQueryAnalyzer queryAnalyzer = new AutoSuggestQueryAnalyzer();
        AutoSuggestIndexAnalyzer indexAnalyzer = new AutoSuggestIndexAnalyzer();
        this.extractor = new ModelEntityExtractor((Analyzer)queryAnalyzer, (Analyzer)indexAnalyzer, modelSource.getEntitySource());
    }

    @Override
    public List<Suggestion> getSuggestions(String query, int maxSuggestions) throws IOException {
        List matches = this.extractor.match(query, maxSuggestions);
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>(matches.size());
        for (EntityMatch match : matches) {
            Suggestion suggestion = new Suggestion(match.getHighlight(), match.getMatchLabel(), match.getEntity().getURI().toString());
            suggestions.add(suggestion);
        }
        return suggestions;
    }
}

