/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.provider.model.poc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.suggest.provider.Suggestion;
import org.eaglei.suggest.provider.SuggestionProvider;
import org.eaglei.suggest.provider.SuggestionSource;

public final class POCModelSuggestionProvider
implements SuggestionProvider {
    private Map<Character, List<Set<SuggestItem>>> suggestIndex = new HashMap<Character, List<Set<SuggestItem>>>();
    private List<String> uris;

    public POCModelSuggestionProvider(String uri) {
        this(Collections.singletonList(uri));
    }

    public POCModelSuggestionProvider(List<String> uris) {
        this.uris = uris;
    }

    @Override
    public void index(SuggestionSource source) throws IOException {
        for (String uri : this.uris) {
            EIClass c = JenaEIOntModel.INSTANCE.getClass(EIURI.create((String)uri));
            this.indexClass(c);
        }
        this.indexingComplete();
    }

    private void indexClass(EIClass c) {
        List listTypeLabels = JenaEIOntModel.INSTANCE.getTypeEntities(c.getEntity().getURI());
        for (EIEntity e : listTypeLabels) {
            this.add(e);
        }
    }

    @Override
    public List<Suggestion> getSuggestions(String query, int maxSuggestions) throws IOException {
        return null;
    }

    private void add(EIEntity entity) {
        String lower = entity.getLabel().trim().toLowerCase();
        String strURI = entity.getURI().toString();
        ArrayList<SuggestItem> tokens = new ArrayList<SuggestItem>();
        tokens.add(new SuggestItem(lower, strURI, 0));
        boolean inSpace = false;
        for (int charIndex = 0; charIndex < lower.length(); ++charIndex) {
            if (lower.charAt(charIndex) == ' ') {
                inSpace = true;
                continue;
            }
            if (!inSpace) continue;
            tokens.add(new SuggestItem(lower, strURI, charIndex));
            inSpace = false;
        }
        for (int tokenIndex = 0; tokenIndex < tokens.size(); ++tokenIndex) {
            SuggestItem token = (SuggestItem)tokens.get(tokenIndex);
            Character startsWith = Character.valueOf(token.endSeg.charAt(0));
            List<Set<SuggestItem>> tokenSetList = this.suggestIndex.get(startsWith);
            if (tokenSetList == null) {
                tokenSetList = new ArrayList<Set<SuggestItem>>();
                this.suggestIndex.put(startsWith, tokenSetList);
            }
            Set<SuggestItem> tokenSet = null;
            for (int j = tokenSetList.size(); j <= tokenIndex; ++j) {
                tokenSet = new TreeSet<SuggestItem>();
                tokenSetList.add(tokenSet);
            }
            if (tokenSet == null) {
                tokenSet = tokenSetList.get(tokenIndex);
            }
            tokenSet.add(token);
        }
    }

    public void indexingComplete() {
    }

    private static class SuggestItem
    implements Comparable<SuggestItem> {
        String text;
        String startSeg;
        String endSeg;
        String uri;

        SuggestItem(String text, String strURI, int startIndex) {
            this.text = text;
            this.startSeg = text.substring(0, startIndex) + "<b>";
            this.endSeg = text.substring(startIndex);
            this.uri = strURI;
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof SuggestItem)) {
                return false;
            }
            return ((SuggestItem)other).text.equals(this.text);
        }

        @Override
        public int compareTo(SuggestItem o) {
            int result = this.endSeg.compareTo(o.endSeg);
            return result != 0 ? result : this.text.compareTo(o.text);
        }
    }
}

