/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.suggest.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.suggest.provider.Suggestion;
import org.eaglei.suggest.provider.SuggestionProvider;
import org.eaglei.suggest.provider.model.lucene.EIModelSuggestionProviderFactory;

public class SuggestionServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final Log logger = LogFactory.getLog(SuggestionServlet.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();
    private boolean isInitialized = false;
    private SuggestionProvider mainProvider;
    private Map<String, SuggestionProvider> mapIdToProvider;

    public void init() throws ServletException {
        Thread logThread = new Thread((Runnable)new SuggestionIndexer(), "SuggestionIndexer");
        logThread.setPriority(1);
        logThread.setDaemon(true);
        logThread.start();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = request.getParameter("id");
        String classid = request.getParameter("classid");
        String q = request.getParameter("q");
        q = q.substring(1, q.length() - 1);
        String asyncCallback = request.getParameter("callback");
        List<Suggestion> suggestions = null;
        if (this.isInitialized) {
            if (classid == null) {
                suggestions = this.mainProvider.getSuggestions(q, 10);
            } else {
                String decodedClassId = URLDecoder.decode(classid);
                SuggestionProvider provider = this.mapIdToProvider.get(decodedClassId);
                if (provider != null) {
                    suggestions = provider.getSuggestions(q, 10);
                } else {
                    logger.warn((Object)("SuggestionServlet: no provider found for [" + decodedClassId + "]"));
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(asyncCallback);
        sb.append("({");
        SuggestionServlet.writeJsonNameValueString(sb, "id", id);
        sb.append(',');
        sb.append("suggestions");
        sb.append(":[");
        if (suggestions != null && suggestions.size() > 0) {
            int i = 0;
            while (true) {
                Suggestion suggestion = suggestions.get(i++);
                sb.append("\"");
                sb.append(suggestion.getDisplayText());
                sb.append("\"");
                sb.append(',');
                SuggestionServlet.writeJsonValueString(sb, suggestion.getReplacementText());
                sb.append(',');
                SuggestionServlet.writeJsonValueString(sb, suggestion.getURI());
                if (i == suggestions.size()) break;
                sb.append(',');
            }
        }
        sb.append("]");
        sb.append("})");
        String output = sb.toString();
        response.setContentType("text/javascript");
        response.addHeader("Pragma", "no-cache");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        out.println(output);
    }

    private static void writeJsonNameValueString(StringBuilder sb, String name, String value) {
        sb.append(name);
        sb.append(":");
        SuggestionServlet.writeJsonValueString(sb, value);
    }

    private static void writeJsonValueString(StringBuilder sb, String value) {
        sb.append("\"");
        sb.append(value);
        sb.append("\"");
    }

    private class SuggestionIndexer
    implements Runnable {
        private SuggestionIndexer() {
        }

        @Override
        public void run() {
            try {
                SuggestionServlet.this.mapIdToProvider = EIModelSuggestionProviderFactory.createProviderForEachTopLevel();
                SuggestionServlet.this.mainProvider = EIModelSuggestionProviderFactory.createProviderForAllRoots();
                if (DEBUG) {
                    logger.debug((Object)"Indexing complete");
                }
                SuggestionServlet.this.isInitialized = true;
            }
            catch (Throwable t) {
                logger.error((Object)t);
            }
        }
    }
}

