package org.eaglei.datatools;

import java.io.Serializable;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class WorkFlowTransition implements Serializable {

	private static final long	serialVersionUID	= 1L;

	private EIEntity			transition;
	private EIEntity			fromState;
	private EIEntity			toState;
	private boolean				allowed;

	public WorkFlowTransition(final EIEntity transition, final EIEntity from, final EIEntity to, final boolean allowed) {
		this.transition = transition;
		fromState = from;
		toState = to;
		this.allowed = allowed;
	}

	private WorkFlowTransition() {
		//For GWT
	}

	//TODO see what getters are needed
	public EIEntity getEntity() {
		return transition;
	}
	
	public String getName() {
		return transition.getLabel();
	}

	public EIURI getURI() {
		return transition.getURI();
	}

	public EIURI getFromStateURI() {
		return fromState.getURI();
	}

	public EIURI getToStateURI() {
		return toState.getURI();
	}

	public boolean isAllowed() {
		return allowed;
	}

	@Override
	public boolean equals(Object obj) {
		WorkFlowTransition workflowTransition = (WorkFlowTransition) obj;
		return transition.getURI().equals(workflowTransition.getURI()) && fromState.getURI().equals(workflowTransition.getFromStateURI()) && toState.getURI().equals(workflowTransition.getToStateURI());

	}

	@Override
	public int hashCode() {
		return transition.hashCode() + fromState.hashCode() + toState.hashCode();
	}

}
