package org.eaglei.datatools;

import java.io.Serializable;

import org.eaglei.model.EIURI;

/**
 * User Workspace representation. User class hold collections of these classes .
 * 
 */
public class Workspace implements Serializable {

	private static final long	serialVersionUID	= 1L;
	private String				workspaceName;
	private EIURI				workspaceURI;
	private boolean				canAdd;
	private boolean				canDelete;

	private EIURI				typeURI;

	public Workspace(final String workspaceName, final EIURI workspaceURI, final EIURI typeURI, final boolean canAdd, final boolean canDelete) {
		this.workspaceName = workspaceName;
		this.workspaceURI = workspaceURI;
		this.typeURI = typeURI;
		this.canAdd = canAdd;
		this.canDelete = canDelete;

	}

	private Workspace() {
		// For GWT
	}

	public String getWorkspaceName() {
		return workspaceName;
	}

	public EIURI getWorkspaceURI() {
		return workspaceURI;
	}

	public boolean canAdd() {
		return canAdd;
	}

	public boolean canDelete() {
		return canDelete;
	}

	public EIURI getTypeURI() {
		return typeURI;
	}

}
