package org.eaglei.datatools.jena;

import java.util.List;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;

public class RDFUtil {

	public static Resource getResourceOfTypeWIthLabel(final Model rdfModel, final RDFNode objectNode, final String label) throws NullPointerException {

		final List<Resource> rList = rdfModel.listResourcesWithProperty( RDF.type, objectNode ).toList();
		for (final Resource r : rList) {
			if ( r.hasLiteral( RDFS.label, label ) ) {
				return r;
			}
		}

		return null;

	}
}