/**
 * The eagle-i consortium
 * Harvard University
 * Nov 4, 2010
 */
package org.eaglei.datatools.provider;

import java.util.List;

import org.eaglei.datatools.User;
import org.eaglei.datatools.Workspace;
import org.eaglei.security.Session;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public interface DatatoolsSecurityProvider {
	public User login(final String userName, final String password) throws Exception;

	public void logout(final Session session) throws Exception;

	public User whoami(Session session) throws Exception;

	public boolean isOnline();

	public List<Workspace> getWorkspaces(Session session) throws Exception;
}
