/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.provider.EIDataToolsProviderException;
import org.eaglei.datatools.provider.RepositoryProviderMessages;
import org.eaglei.security.Session;

public class ProviderUtils {
    private static final Log logger = LogFactory.getLog(ProviderUtils.class);

    public static String getStringFromInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    public static void validateSession(Session session) throws EIDataToolsProviderException {
        if (!Session.isValid((Session)session)) {
            logger.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
    }

    public static String getHttpResponse(HttpClient client, HttpMethod method) throws HttpException, IOException, EIDataToolsProviderException {
        String responseBody;
        int status = 0;
        try {
            status = client.executeMethod(method);
            responseBody = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("", status));
        }
        finally {
            method.releaseConnection();
        }
        if (status == 200 || status == 201) {
            logger.info((Object)("Request succeded with status: " + status));
            return responseBody;
        }
        if (status == 404) {
            logger.error((Object)"Repo unavailable");
            throw new EIDataToolsProviderException("The repository is currently unavailable.");
        }
        if (status == 401) {
            logger.error((Object)"Not authorized to get user information (login/whoami)");
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        if (status == 409) {
            logger.error((Object)("Stale token. Update instance failed with status: " + status + " response: " + responseBody));
            throw new EIDataToolsProviderException("This resource is being edited or has recently changed. Is it open in another window? Cancel and try editing again.");
        }
        logger.error((Object)("Operation failed with status: " + status + " response: " + responseBody));
        throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("", status));
    }
}

