/**
 * 
 */
package org.eaglei.datatools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

/**
 * When user is sucessfully authenticated this object will be created with all the needed user Information filled
 * 
 * @author Sravan Cheriyala
 * 
 */
public class User implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private EIEntity userEntity;

	private Session session;
	private List<Workspace> workspaces;

	private List<WorkFlowTransition> allowedTransitions;
	private Map<EIURI, List<WorkFlowTransition>> workflowStateToAllowedTransitions;
	
	private static final EIURI DRAFT_URI = EIURI.create( "http://eagle-i.org/ont/repo/1.0/WFS_Draft" ); // TODO: duplicated; fix this!

	public User(final String userName, final EIURI userURI, final List<WorkFlowTransition> allowedTransitions, final List<Workspace> workspaces) {
		this.userEntity = EIEntity.create(userURI, userName);
		this.allowedTransitions = allowedTransitions;
		this.workflowStateToAllowedTransitions = fillMapWithList(allowedTransitions);
		this.workspaces = workspaces;
	}

	public User(final String userName, final EIURI userURI, final List<WorkFlowTransition> allowedTransitions, final List<Workspace> workspaces, final Session session) {
		this(userName, userURI, allowedTransitions, workspaces);
		this.session = session;
	}

	private Map<EIURI, List<WorkFlowTransition>> fillMapWithList(List<WorkFlowTransition> allowedTransitions) {
		final Map<EIURI, List<WorkFlowTransition>> mapToReturn = new HashMap<EIURI, List<WorkFlowTransition>>();
		for (WorkFlowTransition transition : allowedTransitions) {
			if (mapToReturn.get(transition.getFromStateURI()) != null) {
				List<WorkFlowTransition> list = mapToReturn.get(transition.getFromStateURI()) ;
				list.add(transition);
			} else {
				List<WorkFlowTransition> list = new ArrayList<WorkFlowTransition>();
				list.add(transition);
				mapToReturn.put(transition.getFromStateURI(), list);
			}

		}
		return mapToReturn;
	}

	private User() {
		// For GWT
	}

	public String getUserName() {
		return userEntity.getLabel();
	}

	public EIURI getUserURI() {
		return userEntity.getURI();
	}
	
	public EIEntity getUserEntity() {
		return userEntity;
	}

	public List<Workspace> getWorkspaces() {
		return workspaces;
	}

	public List<WorkFlowTransition> getAllowedTransitions() {
		return allowedTransitions;
	}

	public Map<EIURI, List<WorkFlowTransition>> getMapOfFromStateToWorkFlowTransitions() {
		return workflowStateToAllowedTransitions;
	}

	public List<WorkFlowTransition> getAllowedTransitionsForState(EIURI wfStateUri) {
		return workflowStateToAllowedTransitions.get(wfStateUri);
	}
	
	public boolean canEdit(EIURI wfStateUri) {
		List<WorkFlowTransition> transitions = workflowStateToAllowedTransitions.get(wfStateUri);

		return transitions != null && transitions.size() != 0;
	}
	
	public Session getSession() {
		return session;
	}

	@Override
	public boolean equals(Object o) {
		if (o != null && o instanceof User) {
			User other = (User) o;
            return other.getUserEntity().equals(getUserEntity());
        }
        return false;
	}

	@Override
	public int hashCode() {
		return getUserEntity().hashCode();  // TODO: more?
	}

	
}
