/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.jena.BulkCurationQueryBuilder;
import org.eaglei.datatools.jena.BulkCurationTriple;
import org.eaglei.datatools.jena.BulkCurationTripleFactory;
import org.eaglei.datatools.jena.QueryBuilder;
import org.eaglei.datatools.jena.TriplesCRUDService;
import org.eaglei.datatools.provider.DataManagmentService;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.AbstractRepositoryProvider;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;

public class DataManagmentProvider
extends AbstractRepositoryProvider
implements DataManagmentService {
    public static final String[] graphs = new String[]{"http://eagle-i.org/ont/repo/1.0/NG_Published", "http://eagle-i.org/ont/repo/1.0/NG_Withdrawn", "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace"};
    protected static final Log activityLogger = LogFactory.getLog((String)"bulk curation activity:");
    private QueryBuilder queryBuilder;
    TriplesCRUDService triplesService;
    private final String repositoryURL;

    public DataManagmentProvider(SecurityProvider generalSecurityProvider, String repositoryURL) {
        this.repositoryURL = repositoryURL;
        this.queryBuilder = BulkCurationQueryBuilder.getInstance();
        this.triplesService = new TriplesCRUDService(generalSecurityProvider, repositoryURL);
    }

    @Override
    public List<BulkCurationTriple> getResourcesToRepair(Session session, EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral) throws RepositoryProviderException {
        ArrayList<BulkCurationTriple> instanceList = new ArrayList<BulkCurationTriple>();
        for (String graph : graphs) {
            String query = this.queryBuilder.diagnoseQuery(typeURI, predicateURI, objectString, this.getObjectTypeByBoolean(isObjectLiteral), graph);
            if (log.isDebugEnabled()) {
                log.debug((Object)("the query to get resource is " + query));
            }
            instanceList.addAll(this.getResourcesToRepair(session, query));
        }
        return instanceList;
    }

    @Override
    public List<BulkCurationTriple> getResourcesToRepairByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex) throws RepositoryProviderException {
        ArrayList<BulkCurationTriple> instanceList = new ArrayList<BulkCurationTriple>();
        for (String graph : graphs) {
            List<BulkCurationTriple> resources = this.getResourcesToRepairByRegexOneGraph(session, typeURI, predicateURI, regex, graph);
            instanceList.addAll(resources);
        }
        return instanceList;
    }

    public List<BulkCurationTriple> getMetadataResourcesToRepairByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex) throws RepositoryProviderException {
        String query = this.queryBuilder.diagnoseQueryByRegexForMetadata(predicateURI, regex, "http://eagle-i.org/ont/repo/1.0/NG_Metadata");
        if (log.isDebugEnabled()) {
            log.debug((Object)("The query to get resources is " + query));
        }
        return this.getResourcesToRepair(session, query);
    }

    private List<BulkCurationTriple> getResourcesToRepair(Session session, String query) throws RepositoryProviderException {
        String graphContent = this.triplesService.getTriplesToDisplay(session, query);
        ResultSet resultSet = ResultSetFactory.fromXML((String)graphContent);
        List<BulkCurationTriple> listOfTriples = BulkCurationTripleFactory.getBulkCurationTriples(resultSet);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning " + listOfTriples.size() + " triples"));
        }
        return listOfTriples;
    }

    private List<BulkCurationTriple> getResourcesToRepairByRegexOneGraph(Session session, EIURI typeURI, EIURI predicateURI, String regex, String graph) throws RepositoryProviderException {
        String query = this.queryBuilder.diagnoseQueryByRegex(typeURI, predicateURI, regex, graph);
        if (log.isDebugEnabled()) {
            log.debug((Object)("The query to get resource is " + query));
        }
        return this.getResourcesToRepair(session, query);
    }

    @Override
    public Integer replaceObject(Session session, EIURI typeURI, EIURI predicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws RepositoryProviderException {
        Integer before = this.SanityCheck(session, typeURI, predicateURI, predicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral), newObjectString, this.getObjectTypeByBoolean(isNewObjectLiteral));
        Integer toReplace = this.triplesService.getCountOfTriples(session, BulkCurationQueryBuilder.getInstance().getSanityCheckQuery(typeURI, predicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral)));
        for (String graph : graphs) {
            String addNewObjectquery = this.queryBuilder.getQueryToAddObject(typeURI, predicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral), newObjectString, this.getObjectTypeByBoolean(isNewObjectLiteral), graph);
            String deleteOldObjectquery = this.queryBuilder.getQueryToDeleteTriple(typeURI, predicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral), graph);
            if (log.isDebugEnabled()) {
                log.debug((Object)("query to add new object triple is " + addNewObjectquery));
                log.debug((Object)("query to delete old object triple is " + deleteOldObjectquery));
            }
            this.replaceResource(session, addNewObjectquery, deleteOldObjectquery, graph);
        }
        Integer after = this.SanityCheck(session, typeURI, predicateURI, predicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral), newObjectString, this.getObjectTypeByBoolean(isNewObjectLiteral));
        if (after - before != 0) {
            throw new RepositoryProviderException("Sanity check failed");
        }
        return new Integer(toReplace);
    }

    @Override
    public Integer replacePredicate(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String objectString, Boolean isObjectLiteral) throws RepositoryProviderException {
        Integer before = this.SanityCheck(session, typeURI, oldPredicateURI, newPredicateURI, objectString, this.getObjectTypeByBoolean(isObjectLiteral), objectString, this.getObjectTypeByBoolean(isObjectLiteral));
        Integer toReplace = this.triplesService.getCountOfTriples(session, BulkCurationQueryBuilder.getInstance().getSanityCheckQuery(typeURI, oldPredicateURI, objectString, this.getObjectTypeByBoolean(isObjectLiteral)));
        for (String graph : graphs) {
            String addNewPredicatequery = this.queryBuilder.getQueryToAddPredicate(typeURI, oldPredicateURI, newPredicateURI, objectString, this.getObjectTypeByBoolean(isObjectLiteral), graph);
            String deleteOldObjectquery = this.queryBuilder.getQueryToDeleteTriple(typeURI, oldPredicateURI, objectString, this.getObjectTypeByBoolean(isObjectLiteral), graph);
            if (log.isDebugEnabled()) {
                log.debug((Object)("query to add new predicate triple is " + addNewPredicatequery));
                log.debug((Object)("query to delete old predicate triple is " + deleteOldObjectquery));
            }
            this.replaceResource(session, addNewPredicatequery, deleteOldObjectquery, graph);
        }
        Integer after = this.SanityCheck(session, typeURI, oldPredicateURI, newPredicateURI, objectString, this.getObjectTypeByBoolean(isObjectLiteral), objectString, this.getObjectTypeByBoolean(isObjectLiteral));
        if (after - before != 0) {
            throw new RepositoryProviderException("Sanity check failed");
        }
        return new Integer(toReplace);
    }

    @Override
    public Integer replaceObjectAndPredicate(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws RepositoryProviderException {
        Integer before = this.SanityCheck(session, typeURI, oldPredicateURI, newPredicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral), newObjectString, this.getObjectTypeByBoolean(isNewObjectLiteral));
        Integer toReplace = this.triplesService.getCountOfTriples(session, BulkCurationQueryBuilder.getInstance().getSanityCheckQuery(typeURI, oldPredicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral)));
        for (String graph : graphs) {
            String addNewObjectAndPredicatequery = this.queryBuilder.getQueryToAddPredicateAndObject(typeURI, oldPredicateURI, newPredicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral), newObjectString, this.getObjectTypeByBoolean(isNewObjectLiteral), graph);
            String deleteOldObjectquery = this.queryBuilder.getQueryToDeleteTriple(typeURI, oldPredicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral), graph);
            if (log.isDebugEnabled()) {
                log.debug((Object)("query to add new predicate and object triple is " + addNewObjectAndPredicatequery));
                log.debug((Object)("query to delete old  triple is " + deleteOldObjectquery));
            }
            this.replaceResource(session, addNewObjectAndPredicatequery, deleteOldObjectquery, graph);
        }
        Integer after = this.SanityCheck(session, typeURI, oldPredicateURI, newPredicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral), newObjectString, this.getObjectTypeByBoolean(isNewObjectLiteral));
        if (after - before != 0) {
            throw new RepositoryProviderException("Sanity check failed");
        }
        return new Integer(toReplace);
    }

    @Override
    public Integer replaceObjectByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex, String replaceRegex) throws RepositoryProviderException {
        for (String graph : graphs) {
            this.replaceObjectByRegexForOneGraph(session, typeURI, predicateURI, regex, replaceRegex, graph);
        }
        return new Integer(1);
    }

    private void replaceObjectByRegexForOneGraph(Session session, EIURI typeURI, EIURI predicateURI, String regex, String replaceRegex, String graph) throws RepositoryProviderException {
        String constructQryByRegex = this.queryBuilder.getConstructQueryByRegex(typeURI, predicateURI, regex, graph);
        String graphContent = this.triplesService.getTriplesToRepair(session, constructQryByRegex);
        String regexReplacedGraphContent = this.doRegexOperationOnGraph(graphContent, regex, replaceRegex);
        this.triplesService.addNewTriples(session, regexReplacedGraphContent, graph);
        this.triplesService.deleteOldTriple(session, graphContent, graph);
    }

    public Integer deleteMetadataObjectByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex) throws RepositoryProviderException {
        String query = this.queryBuilder.getQueryToDeleteTriplesByRegexForMetadata(predicateURI, regex, "http://eagle-i.org/ont/repo/1.0/NG_Metadata");
        String graphContent = this.triplesService.getTriplesToRepair(session, query);
        this.triplesService.deleteOldTriple(session, graphContent, "http://eagle-i.org/ont/repo/1.0/NG_Metadata");
        return new Integer(1);
    }

    @Override
    public Integer deleteTriple(Session session, EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral) throws RepositoryProviderException {
        for (String graph : graphs) {
            String removeTriplesQuery = this.queryBuilder.getQueryToDeleteTriple(typeURI, predicateURI, objectString, this.getObjectTypeByBoolean(isObjectLiteral), graph);
            String graphContent = this.triplesService.getTriplesToRepair(session, removeTriplesQuery);
            this.triplesService.deleteOldTriple(session, graphContent, graph);
            this.logUserActivity(graph, graphContent, "");
        }
        return null;
    }

    @Override
    public Integer addTriple(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws RepositoryProviderException {
        for (String graph : graphs) {
            String addNewObjectAndPredicatequery = this.queryBuilder.getQueryToAddPredicateAndObject(typeURI, oldPredicateURI, newPredicateURI, oldObjectString, this.getObjectTypeByBoolean(isOldObjectLiteral), newObjectString, this.getObjectTypeByBoolean(isNewObjectLiteral), graph);
            String graphContent = this.triplesService.getTriplesToRepair(session, addNewObjectAndPredicatequery);
            this.triplesService.addNewTriples(session, graphContent, graph);
            this.logUserActivity(graph, "", addNewObjectAndPredicatequery);
        }
        return null;
    }

    private void replaceResource(Session session, String addNewObjectQuery, String deleteOldObjectQuery, String graph) throws RepositoryProviderException {
        String addTripleGraphContent = this.triplesService.getTriplesToRepair(session, addNewObjectQuery);
        String removeTripleGraphContent = this.triplesService.getTriplesToRepair(session, deleteOldObjectQuery);
        this.triplesService.addNewTriples(session, addTripleGraphContent, graph);
        this.triplesService.deleteOldTriple(session, removeTripleGraphContent, graph);
        this.logUserActivity(graph, removeTripleGraphContent, addTripleGraphContent);
    }

    private String doRegexOperationOnGraph(String graphContent, String regex, String replaceRegex) {
        Pattern instancePattern = Pattern.compile(regex, 10);
        Matcher match = instancePattern.matcher(graphContent);
        String resultGraph = match.replaceAll(replaceRegex);
        return resultGraph;
    }

    private QueryBuilder.RDFobjectType getObjectTypeByBoolean(Boolean isObjectLiteral) {
        if (isObjectLiteral.booleanValue()) {
            return QueryBuilder.RDFobjectType.objectIsLiteral;
        }
        return QueryBuilder.RDFobjectType.objectIsResource;
    }

    public Integer SanityCheck(Session session, EIURI type, EIURI oldPredicate, EIURI newPredicate, String oldObject, QueryBuilder.RDFobjectType oldObjectType, String newObject, QueryBuilder.RDFobjectType newObjectType) throws RepositoryProviderException {
        String queryForOld = BulkCurationQueryBuilder.getInstance().getSanityCheckQuery(type, oldPredicate, oldObject, oldObjectType);
        String queryForNew = BulkCurationQueryBuilder.getInstance().getSanityCheckQuery(type, newPredicate, newObject, newObjectType);
        Integer oldCount = this.triplesService.getCountOfTriples(session, queryForOld);
        Integer newCount = this.triplesService.getCountOfTriples(session, queryForNew);
        return oldCount + newCount;
    }

    private void logUserActivity(String namedGraph, String oldTripleGraph, String newTripleGraph) {
        activityLogger.info((Object)("Graph name: " + namedGraph));
        activityLogger.info((Object)"---------------------Old Triples-----------");
        activityLogger.info((Object)oldTripleGraph);
        activityLogger.info((Object)"---------------------new Triples-----------");
        activityLogger.info((Object)newTripleGraph);
    }

    public String getDefaultRepositoryProviderURI() {
        return DEFAULT_REPOSITORY_URL;
    }
}

