/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.jena.DatatoolsMetadataConstants;
import org.eaglei.datatools.jena.FooRepositorySecurityProvider;
import org.eaglei.datatools.jena.XmlStringPart;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.EIInstanceMinimalFactory;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.model.jena.SPARQLQueryUtil;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.Session;
import org.eaglei.services.repository.AbstractRepositoryProvider;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;

public final class RESTRepositoryProvider
extends AbstractRepositoryProvider
implements RepositoryProvider {
    private final JenaEIInstanceFactory instanceFactory;
    private EIInstanceMinimalFactory minimalFactory;
    private final FooRepositorySecurityProvider securityProvider;
    private static final String RDF_FORMAT = "RDF/XML";
    private static final String READ_VIEW = "user";

    public RESTRepositoryProvider(EIOntModel ontModel, SecurityProvider commonSecurityProvider) {
        this.minimalFactory = new EIInstanceMinimalFactory(ontModel);
        this.instanceFactory = new JenaEIInstanceFactory(ontModel);
        this.securityProvider = new FooRepositorySecurityProvider(commonSecurityProvider);
    }

    public FooRepositorySecurityProvider getDatatoolsSecurityProvider() {
        return this.securityProvider;
    }

    @Override
    public List<EIURI> getNewInstanceID(Session session, int count) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.GetNewInstanceIDs.getURL());
        method.setParameter("accept", "application/sparql-results+xml");
        method.setParameter("count", Integer.toString(count));
        log.info((Object)("getting " + count + " instance IDs"));
        String responseBody = ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
        ResultSet results = ResultSetFactory.fromXML((String)responseBody);
        ArrayList<EIURI> instances = new ArrayList<EIURI>(count);
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            Resource r = soln.getResource("new");
            String id = r.getURI();
            instances.add(EIURI.create((String)id));
            log.info((Object)("Created new instance id: " + id));
        }
        if (isDebugEnabled) {
            log.debug((Object)("Created " + instances.size() + " ids"));
        }
        if (instances.isEmpty()) {
            throw new RepositoryProviderException("unable to get requested instance IDs");
        }
        return instances;
    }

    @Override
    public EIInstance getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        EIInstance instance = this.instanceFactory.createEmpty(classUri, instanceEntity);
        if (this.isNull(instance)) {
            throw new RepositoryProviderException("Unable to create empty instance of class: " + classUri + " and entity " + instanceEntity);
        }
        return instance;
    }

    @Override
    public EIInstance getEmptyEIInstance(Session session, EIURI classUri) throws RepositoryProviderException {
        EIInstance instance;
        this.securityProvider.isValid(session.getSessionId(), true);
        List<EIURI> ids = this.getNewInstanceID(session, 1);
        if (isDebugEnabled) {
            log.debug((Object)("New instance ID is: " + ids.get(0)));
        }
        if (this.isNull(instance = this.instanceFactory.createEmpty(classUri, EIEntity.create((EIURI)ids.get(0), (String)"")))) {
            throw new RepositoryProviderException("Unable to create empty instance of class: " + classUri);
        }
        return instance;
    }

    private String getToken(Session session, String instanceUri) throws RepositoryProviderException {
        return this.updateAndGetToken(session, null, instanceUri);
    }

    @Override
    public String getToken(Session session, EIInstance instance) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (this.isNull(instance)) {
            log.warn((Object)"trying to get token to update invalid instance");
            return null;
        }
        return this.getToken(session, instance.getInstanceURI().toString());
    }

    @Override
    public Map<EIInstance, String> getTokens(Session session, List<EIInstance> instances) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (instances == null) {
            log.warn((Object)"trying to get token to update invalid instance list");
            return null;
        }
        HashMap<EIInstance, String> result = new HashMap<EIInstance, String>();
        for (EIInstance instance : instances) {
            result.put(instance, this.getToken(session, instance));
        }
        return result;
    }

    @Override
    public void updateInstance(Session session, EIInstance instance, String token) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (this.isNull(instance)) {
            log.warn((Object)"Trying to update instance with null instance or null instance URI");
            return;
        }
        if (instance.isExtendedInstance()) {
            instance.setReadOnlyLiteralProperties(new HashMap());
        }
        ArrayList<EIURI> mainAndEmbeddedUris = new ArrayList<EIURI>();
        mainAndEmbeddedUris.add(instance.getInstanceURI());
        if (!instance.isStub()) {
            EIInstance existingInstance = this.getOneInstance(session, instance.getInstanceURI(), true);
            if (existingInstance.hasEmbeddedInstances()) {
                mainAndEmbeddedUris.addAll(existingInstance.getEmbeddedInstanceUriList());
            }
            if (instance.hasEmbeddedInstances()) {
                this.removeEmptyEmbeddedInstances(instance);
            }
        }
        String instanceAsString = this.instanceFactory.serialize(instance, RDF_FORMAT);
        String instanceUri = instance.getInstanceURI().toString();
        this.updateOneInstance(session, instanceAsString, instanceUri, mainAndEmbeddedUris, token);
    }

    public String updateInstance(Session session, String rdfString, String instanceUri, String token) throws RepositoryProviderException {
        return this.updateOneInstance(session, rdfString, instanceUri, Arrays.asList(EIURI.create((String)instanceUri)), token);
    }

    @Override
    public void updateInstances(Session session, Map<EIInstance, String> instancesWithTokens) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (instancesWithTokens == null) {
            log.warn((Object)"trying to update invalid instance list");
            return;
        }
        for (EIInstance instance : instancesWithTokens.keySet()) {
            log.debug((Object)("Updating one instance in list: " + instance));
            this.updateInstance(session, instance, instancesWithTokens.get(instance));
        }
    }

    @Override
    public void createInstances(Session session, List<EIInstance> instances, EIEntity workspaceEntity) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (instances == null) {
            log.warn((Object)"trying to create instances with null list");
            return;
        }
        if (isDebugEnabled) {
            log.debug((Object)("bulk-creating " + instances.size() + " instances"));
        }
        for (EIInstance instance : instances) {
            if (isDebugEnabled) {
                log.debug((Object)("bulk-creating instance " + instance.getInstanceLabel()));
            }
            this.createInstance(session, instance, workspaceEntity);
        }
    }

    @Override
    public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity) throws RepositoryProviderException {
        log.info((Object)("Instance label is   " + instance.getInstanceLabel().toString()));
        this.securityProvider.isValid(session.getSessionId(), true);
        if (this.isNull(instance)) {
            log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
            return;
        }
        if (instance.hasEmbeddedInstances()) {
            this.removeEmptyEmbeddedInstances(instance);
        }
        String instanceUri = instance.getInstanceURI().toString();
        String instanceAsString = this.instanceFactory.serialize(instance, RDF_FORMAT);
        this.createInstance(session, instanceAsString, instanceUri, workspaceEntity);
    }

    public void createInstance(Session session, String rdfString, String instanceUri, EIEntity workspaceEntity) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (rdfString == null) {
            log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
            return;
        }
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.UpdateInstance.getURL());
        StringPart idPart = new StringPart("uri", instanceUri, "utf-8");
        StringPart workspacePart = null;
        workspacePart = workspaceEntity != null && !workspaceEntity.equals((Object)EIEntity.NULL_ENTITY) ? new StringPart("workspace", workspaceEntity.getURI().toString(), "UTF-8") : new StringPart("workspace", DEFAULT_WORKSPACE_ENTITY.getURI().toString(), "UTF-8");
        StringPart actionPart = new StringPart("action", "create");
        XmlStringPart insertPart = new XmlStringPart("insert", rdfString, "UTF-8");
        Part[] parts = new Part[]{workspacePart, actionPart, insertPart, idPart};
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
        if (isDebugEnabled) {
            log.debug((Object)("Trying to create instance at " + instanceUri));
        }
        ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
    }

    @Override
    public EIInstance deepCopy(Session session, EIURI originalUri) throws RepositoryProviderException {
        EIInstance instance;
        this.securityProvider.isValid(session.getSessionId(), true);
        EIInstance original = this.getOneInstance(session, originalUri, true);
        if (isDebugEnabled) {
            log.debug((Object)"got original instance");
        }
        if (this.isNull(instance = this.duplicateInstance(session, original))) {
            throw new RepositoryProviderException("result of deepcopy is null for instance: " + originalUri);
        }
        return instance;
    }

    @Override
    public void deleteInstances(Session session, List<EIURI> instanceUris) throws RepositoryProviderException {
        for (EIURI instanceUri : instanceUris) {
            this.deleteInstance(session, instanceUri);
        }
    }

    @Override
    public void deleteInstance(Session session, EIURI instanceUri) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (instanceUri == null || instanceUri.toString() == null || instanceUri.toString().length() == 0) {
            return;
        }
        this.deleteOneInstance(session, instanceUri);
    }

    @Override
    public Map<EIURI, String> getModifiedDates(Session session, List<EIURI> uris) throws RepositoryProviderException {
        HashMap<EIURI, String> uriToModifiedDate = new HashMap<EIURI, String>();
        for (EIURI uri : uris) {
            String date = this.getModifiedDate(session, uri);
            if (isDebugEnabled) {
                log.debug((Object)date);
            }
            uriToModifiedDate.put(uri, date);
        }
        return uriToModifiedDate;
    }

    private void deleteOneInstance(Session session, EIURI instanceUri) throws RepositoryProviderException {
        ArrayList<EIURI> urisToDelete = new ArrayList<EIURI>();
        urisToDelete.add(instanceUri);
        EIInstance outerInstance = this.getOneInstance(session, instanceUri, true);
        if (outerInstance.hasEmbeddedInstances()) {
            urisToDelete.addAll(outerInstance.getEmbeddedInstanceUriList());
        }
        String token = this.getToken(session, instanceUri.toString());
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.UpdateInstance.getURL());
        this.setWriteParameters(method, instanceUri.toString());
        method.setParameter("action", "update");
        method.setParameter("token", token);
        method.setParameter("delete", this.createDeleteStatement(urisToDelete));
        if (isDebugEnabled) {
            log.debug((Object)("Trying to delete instance at " + instanceUri.toString()));
        }
        ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
    }

    private String getModifiedDate(Session session, EIURI uri) throws RepositoryProviderException {
        String query = SPARQLQueryUtil.getInstance().getModifiedDateQuery(uri);
        String result = this.postQuery(session, query, READ_VIEW);
        ResultSet resultSet = ResultSetFactory.fromXML((String)result);
        String modifiedDate = "";
        while (resultSet.hasNext()) {
            QuerySolution qs = resultSet.next();
            if (!qs.contains("r_last_modified")) continue;
            modifiedDate = qs.getLiteral("r_last_modified").getString();
        }
        return modifiedDate;
    }

    @Override
    @Deprecated
    public boolean addLabToUser(Session session, EIURI labUri) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (labUri == null) {
            log.warn((Object)"Trying to associate with null lab");
            return false;
        }
        log.info((Object)("addLabToUser : " + labUri));
        String content = "<" + session.getUserURI() + "> <" + DatatoolsMetadataConstants.IsWatchingLabUri.toString() + "> <" + labUri + "> .";
        log.info((Object)(" rdf user lab string: " + content));
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.Graph.getURL());
        method.setParameter("format", "text/plain");
        method.setParameter("name", "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace");
        method.setParameter("type", "workspace");
        method.setParameter("action", "add");
        method.setParameter("content", content);
        try {
            ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
            return true;
        }
        catch (RepositoryProviderException e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public List<EIInstanceMinimal> EIQuery(Session session, String sparql) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (isDebugEnabled) {
            log.debug((Object)("Sparql: " + sparql));
        }
        ResultSet resultSet = ResultSetFactory.fromXML((String)this.postQuery(session, sparql));
        return this.minimalFactory.create(resultSet);
    }

    @Override
    public List<EIInstanceMinimal> listResourcesForObjectPropertyValue(Session session, EIURI classUri, EIURI provider, EIURI state, boolean onlyProvider) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        String query = SPARQLQueryUtil.getInstance().getResourcesForObjectPropertyValuesQuery(classUri, provider, state, onlyProvider);
        return this.EIQuery(session, query);
    }

    @Override
    public String query(Session session, String sparql) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        return this.postQuery(session, sparql);
    }

    @Override
    public String retrieveLabel(Session session, EIURI uri) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        String q = SPARQLQueryUtil.getInstance().getRetrieveLabelQuery(uri);
        if (isDebugEnabled) {
            log.debug((Object)("retrieve label query: " + q));
        }
        String result = this.postQuery(session, q, READ_VIEW);
        if (isDebugEnabled) {
            log.debug((Object)("result " + result));
        }
        ResultSet resultSet = ResultSetFactory.fromXML((String)result);
        ArrayList<String> labels = new ArrayList<String>();
        while (resultSet.hasNext()) {
            QuerySolution qs = resultSet.next();
            if (!qs.contains("r_label")) continue;
            labels.add(qs.getLiteral("r_label").getString());
        }
        return labels.isEmpty() ? "" : (String)labels.get(0);
    }

    @Override
    public EIInstance setReferencingResources(Session session, EIInstance instance) throws RepositoryProviderException {
        ResultSet results = ResultSetFactory.fromXML((String)this.postQuery(session, SPARQLQueryUtil.getInstance().getReferencedByQuery(instance.getInstanceURI())));
        this.minimalFactory.setReferencingInstances(instance, results);
        return instance;
    }

    @Override
    public EIInstance getOneInstance(Session session, EIURI instanceUri, boolean isExtended) throws RepositoryProviderException {
        String responseBody;
        EIInstance eiInstance;
        this.securityProvider.isValid(session.getSessionId(), true);
        if (instanceUri == null || instanceUri.toString() == null || EIURI.NULL_EIURI.equals((Object)instanceUri)) {
            log.warn((Object)"Trying to get instance for null EIURI");
            throw new RepositoryProviderException("Trying to get instance for null EIURI");
        }
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.GetInstance.getURL());
        this.setReadParameters(method);
        method.setParameter("uri", instanceUri.toString());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get instance " + instanceUri.toString()));
        }
        if (this.isNull(eiInstance = this.instanceFactory.createExtended(instanceUri, responseBody = ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method), RDF_FORMAT))) {
            throw new RepositoryProviderException("Unable to create EIInstance for instanceUri: " + instanceUri);
        }
        eiInstance.setStubs(this.getAllStubEntities(session, eiInstance));
        return eiInstance;
    }

    @Override
    public List<EIInstanceMinimal> listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean isAscending, boolean strictOwnerFilter) throws RepositoryProviderException {
        return this.listResources(session, queryRequest, orderBy, isAscending, strictOwnerFilter, false);
    }

    @Override
    public List<EIInstanceMinimal> listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean isAscending, boolean strictOwnerFilter, boolean stubsOnly) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.ListResources.getURL());
        EIURI state = queryRequest.getWFState();
        if (state != null && !state.equals((Object)EIURI.NULL_EIURI)) {
            method.setParameter("state", state.toString());
        } else {
            method.setParameter("state", "all");
        }
        StringBuilder sparql = new StringBuilder();
        EIURI classUri = queryRequest.getType();
        if (classUri != null && !classUri.equals((Object)EIURI.NULL_EIURI) && !SPARQLQueryUtil.getInstance().isClassGroup(classUri)) {
            method.setParameter("type", classUri.toString());
        } else if (SPARQLQueryUtil.getInstance().isClassGroup(classUri)) {
            sparql.append(SPARQLQueryUtil.getInstance().getClassGroupPattern(classUri));
        } else {
            sparql.append(SPARQLQueryUtil.getInstance().allTypesPattern(!stubsOnly));
        }
        EIURI provider = queryRequest.getLab();
        if (provider != null && !provider.equals((Object)EIURI.NULL_EIURI)) {
            sparql.append(SPARQLQueryUtil.getInstance().providerRestrictionPattern(provider));
        } else {
            sparql.append(SPARQLQueryUtil.getInstance().providerRestrictionPattern(EIURI.NULL_EIURI));
        }
        sparql.append(SPARQLQueryUtil.getInstance().getStubPattern(!stubsOnly));
        String sortOrder = "";
        if (!isAscending) {
            sortOrder = "DESC";
        }
        this.commonListResourcesMethodSetup(EIURI.create((String)session.getUserURI()), queryRequest, orderBy, sortOrder, strictOwnerFilter, sparql, method);
        ResultSet resultSet = ResultSetFactory.fromXML((String)ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method));
        List results = this.minimalFactory.create(resultSet);
        if (isDebugEnabled) {
            log.debug((Object)("number of resources retrieved: " + results.size()));
        }
        return results;
    }

    @Override
    public List<EIInstanceMinimal> listReferencingResources(Session session, EIURI resourceUri, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.ListResources.getURL());
        method.setParameter("state", "all");
        StringBuilder sparql = new StringBuilder();
        sparql.append(SPARQLQueryUtil.getInstance().allTypesPattern(false));
        sparql.append(SPARQLQueryUtil.getInstance().providerRestrictionPattern(EIURI.NULL_EIURI));
        sparql.append(SPARQLQueryUtil.getInstance().referencedByPattern(resourceUri));
        this.commonListResourcesMethodSetup(EIURI.create((String)session.getUserURI()), queryRequest, orderBy, "", strictOwnerFilter, sparql, method);
        ResultSet resultSet = ResultSetFactory.fromXML((String)ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method));
        List results = this.minimalFactory.create(resultSet);
        return results;
    }

    @Override
    public List<EIURI> claim(Session session, List<EIURI> uris) throws RepositoryProviderException {
        ArrayList<EIURI> successes = new ArrayList<EIURI>();
        this.securityProvider.isValid(session.getSessionId(), true);
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.Claim.getURL());
        for (EIURI uri : uris) {
            method.setParameter("uri", uri.toString());
            try {
                ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
                successes.add(uri);
            }
            catch (RepositoryProviderException e) {
                log.warn((Object)("could not claim " + uri));
            }
        }
        return successes;
    }

    @Override
    public List<EIURI> release(Session session, List<EIURI> uris) throws RepositoryProviderException {
        log.info((Object)("releasing " + uris.size() + " uris"));
        ArrayList<EIURI> successes = new ArrayList<EIURI>();
        this.securityProvider.isValid(session.getSessionId(), true);
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.Release.getURL());
        for (EIURI uri : uris) {
            method.setParameter("uri", uri.toString());
            try {
                ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
                successes.add(uri);
            }
            catch (RepositoryProviderException e) {
                log.warn((Object)("could not release " + uri));
            }
        }
        return successes;
    }

    @Override
    public List<EIURI> transition(Session session, List<EIURI> uris, EIEntity transitionEntity) throws RepositoryProviderException {
        ArrayList<EIURI> successes = new ArrayList<EIURI>();
        this.securityProvider.isValid(session.getSessionId(), true);
        for (EIURI uri : uris) {
            PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.Transition.getURL());
            method.setParameter("uri", uri.toString());
            method.setParameter("transition", transitionEntity.getURI().toString());
            try {
                ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
                successes.add(uri);
            }
            catch (RepositoryProviderException e) {
                log.warn((Object)("could not transition " + uri));
            }
        }
        return successes;
    }

    protected void setWriteParameters(PostMethod method, String id) {
        method.setParameter("uri", id);
        method.setParameter("format", "application/xml");
        method.setRequestHeader("charset", "UTF-8");
    }

    protected void setReadParameters(PostMethod method) {
        method.setParameter("format", "application/xml");
        method.setParameter("view", READ_VIEW);
        method.setParameter("noinferred", "true");
        method.setRequestHeader("charset", "UTF-8");
    }

    private void removeEmptyEmbeddedInstances(EIInstance instance) {
        for (EIInstance embedded : instance.getEmbeddedInstanceList()) {
            if (embedded.getInstanceLabel().length() != 0) continue;
            instance.removeEmbeddedInstance(embedded.getEntity());
        }
    }

    private boolean isNull(EIInstance instance) {
        return instance == null || instance.getInstanceURI() == null || EIInstance.NULL_INSTANCE.equals(instance);
    }

    private String encodeToUTF8(String rdfString) throws UnsupportedEncodingException {
        return new String(rdfString.getBytes("UTF-8"));
    }

    public EIInstance duplicateInstance(Session session, EIInstance original) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        EIInstance duplicate = this.getEmptyEIInstance(session, original.getInstanceType().getURI());
        if (duplicate == null) {
            throw new RepositoryProviderException("unable to duplicate instance: " + original);
        }
        for (EIEntity property : original.getDatatypeProperties().keySet()) {
            for (String value : original.getDatatypeProperty(property)) {
                duplicate.addDatattypeProperty(property, value);
            }
        }
        boolean checkForEmbedded = original.hasEmbeddedInstances();
        for (EIEntity property : original.getObjectProperties().keySet()) {
            for (Object value : original.getObjectProperty(property)) {
                if (checkForEmbedded && original.getEmbeddedInstances().keySet().contains(value)) {
                    EIInstance duplicateEmbedded = this.duplicateInstance(session, original.getEmbeddedInstance(value));
                    duplicate.addEmbeddedInstance(property, duplicateEmbedded);
                    duplicateEmbedded.setInstanceLabel(original.getEmbeddedInstance(value).getInstanceLabel());
                    duplicate.addObjectProperty(property, duplicateEmbedded.getEntity());
                    continue;
                }
                duplicate.addObjectProperty(property, value);
            }
        }
        for (EIEntity property : original.getNonOntologyLiteralProperties().keySet()) {
            for (Object value : original.getNonOntologyLiteralProperty(property)) {
                duplicate.addNonOntologyLiteralProperty(property, (String)value);
            }
        }
        for (EIEntity property : original.getNonOntologyResourceProperties().keySet()) {
            for (Object value : original.getNonOntologyResourceProperty(property)) {
                duplicate.addNonOntologyResourceProperty(property, value);
            }
        }
        if (isDebugEnabled) {
            log.debug((Object)"finished making new copy");
        }
        return duplicate;
    }

    private String updateOneInstance(Session session, String rdfString, String instanceUri, List<EIURI> mainAndEmbeddedUris, String token) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (rdfString == null || rdfString.length() == 0) {
            log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
            return null;
        }
        if (token == null) {
            return this.updateAndGetToken(session, rdfString, instanceUri);
        }
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.UpdateInstance.getURL());
        StringPart idPart = new StringPart("uri", instanceUri, "UTF-8");
        StringPart actionPart = new StringPart("action", "update");
        XmlStringPart insertPart = new XmlStringPart("insert", rdfString, "UTF-8");
        XmlStringPart deletePart = new XmlStringPart("delete", this.createDeleteStatement(mainAndEmbeddedUris), "UTF-8");
        StringPart tokenPart = new StringPart("token", token);
        Part[] parts = new Part[]{idPart, actionPart, insertPart, deletePart, tokenPart};
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
        if (isDebugEnabled) {
            log.debug((Object)("Trying to update instance at " + instanceUri));
        }
        return ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDeleteStatement(List<EIURI> instanceUris) {
        String s = null;
        StringBuilder wildcard = new StringBuilder();
        for (EIURI instanceUri : instanceUris) {
            wildcard.append(this.createDeleteWildcard(instanceUri));
            wildcard.append("\n");
        }
        log.info((Object)("creating a wildcard graph to delete all the statements: " + wildcard.toString()));
        Model m = ModelFactory.createDefaultModel();
        StringReader st = new StringReader(wildcard.toString());
        m.read((Reader)st, null, "N-TRIPLE");
        StringWriter sw = new StringWriter();
        try {
            m.write((Writer)sw, RDF_FORMAT);
            s = sw.toString();
            sw.flush();
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("createDelete statement: " + e));
            }
        }
        return s;
    }

    private String createDeleteWildcard(EIURI instanceUri) {
        String wildcard = "<" + instanceUri.toString() + "> <http://eagle-i.org/ont/repo/1.0/MatchAnything> <http://eagle-i.org/ont/repo/1.0/MatchAnything> .";
        return wildcard;
    }

    private String updateAndGetToken(Session session, String rdfString, String instanceUri) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        ArrayList<StringPart> partsList = new ArrayList<StringPart>();
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.UpdateInstance.getURL());
        StringPart idPart = new StringPart("uri", instanceUri, "UTF-8");
        StringPart actionPart = new StringPart("action", "gettoken", "UTF-8");
        partsList.add(idPart);
        partsList.add(actionPart);
        if (rdfString != null && rdfString.length() > 0) {
            XmlStringPart insertPart = new XmlStringPart("insert", rdfString, "UTF-8");
            partsList.add(insertPart);
        }
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(partsList.toArray(new Part[partsList.size()]), method.getParams()));
        String resp = ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
        return this.parseResponseToken(resp);
    }

    private String parseResponseToken(String resp) {
        ResultSet results = ResultSetFactory.fromXML((String)resp);
        QuerySolution soln = results.nextSolution();
        Resource r = soln.getResource("token");
        String tokenid = r.getURI();
        log.info((Object)("Retrieved new token " + tokenid));
        return tokenid;
    }

    protected Set<EIEntity> getAllStubEntities(Session session, EIInstance instance) throws RepositoryProviderException {
        Set<EIEntity> stubs = this.getStubEntities(session, instance.getInstanceURI());
        if (instance.hasEmbeddedInstances()) {
            for (EIURI embeddedUri : instance.getEmbeddedInstanceUriList()) {
                stubs.addAll(this.getStubEntities(session, embeddedUri));
            }
        }
        return stubs;
    }

    private Set<EIEntity> getStubEntities(Session session, EIURI instanceUri) throws RepositoryProviderException {
        ResultSet results = ResultSetFactory.fromXML((String)this.postQuery(session, SPARQLQueryUtil.getInstance().getRetrieveStubsQuery(instanceUri)));
        HashSet<EIEntity> stubs = new HashSet<EIEntity>();
        while (results.hasNext()) {
            QuerySolution solution = results.nextSolution();
            if (!solution.contains("r_subject") || !solution.contains("r_label")) continue;
            EIURI uri = EIURI.create((String)solution.getResource("r_subject").getURI());
            String label = solution.getLiteral("r_label").getString();
            stubs.add(EIEntity.create((EIURI)uri, (String)label));
        }
        return stubs;
    }

    private synchronized String postQuery(Session session, String q) throws RepositoryProviderException {
        return this.postQuery(session, q, READ_VIEW);
    }

    private synchronized String postQuery(Session session, String q, String view) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        if (q == null) {
            log.warn((Object)"Null query!");
            return null;
        }
        PostMethod method = new PostMethod(AbstractRepositoryProvider.RestCommands.Query.getURL());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to query: " + AbstractRepositoryProvider.RestCommands.Query.getURL()));
        }
        this.setReadParameters(method);
        method.setParameter("view", view);
        try {
            method.setParameter("query", this.encodeToUTF8(q));
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("could not encode to utf-8: " + e.getMessage()));
            log.warn((Object)("will send unencoded query string: " + q));
            method.setParameter("query", q);
        }
        return ProviderUtils.getHttpResponse((HttpClient)this.securityProvider.getHttpClient(session), (HttpMethod)method);
    }

    private void commonListResourcesMethodSetup(EIURI user, AuthSearchRequest queryRequest, SortByProperties orderBy, String sortOrder, boolean strictOwnerFilter, StringBuilder sparql, PostMethod method) {
        method.setParameter("detail", "full");
        method.setParameter("format", "application/xml");
        if (strictOwnerFilter) {
            method.setParameter("owner", "self");
            method.setParameter("unclaimed", "false");
        } else {
            method.setParameter("owner", "all");
            method.setParameter("unclaimed", "true");
        }
        sparql.append(SPARQLQueryUtil.getInstance().modifiedDatePattern());
        if (orderBy == SortByProperties.status || orderBy == SortByProperties.type) {
            sparql.append(SPARQLQueryUtil.getInstance().additionalLabelsPattern());
        }
        sparql.append(" filter(!regex(str(?").append("r_created").append("), \"http://www.w3.org/2001/XMLSchema#dateTime\"))");
        sparql.append(" filter(bound(?").append("r_label").append("))");
        if (isDebugEnabled) {
            log.debug((Object)("Sparql pattern sent to workflow/resources is: " + sparql.toString()));
        }
        try {
            method.setParameter("addPattern", this.encodeToUTF8(sparql.toString()));
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("could not encode to utf-8: " + e.getMessage()));
            log.warn((Object)("will send unencoded query string pattern: " + sparql.toString()));
            method.setParameter("addPattern", sparql.toString());
        }
        method.setParameter("addResults", "?r_provider ?r_providerName ?r_last_modified ?r_is_stub");
        StringBuilder modifiers = new StringBuilder();
        modifiers.append(" ORDER BY " + sortOrder + "( <http://eagle-i.org/ont/repo/1.0/upperCaseStr>(?").append(orderBy.getVariable()).append(") )");
        if (queryRequest.isPaginated() && queryRequest.getMaxResults() > 0 && queryRequest.getStartIndex() >= 0) {
            modifiers.append("LIMIT ").append(String.valueOf(queryRequest.getMaxResults())).append(" OFFSET ").append(String.valueOf(queryRequest.getStartIndex()));
        }
        method.setParameter("addModifiers", modifiers.toString());
        if (isDebugEnabled) {
            log.debug((Object)("modifiers sent to workflow/resources are: " + modifiers.toString()));
        }
    }
}

