/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.logging;

import java.util.Date;

public final class JSLogger {
    private final String name;
    private final Level threshold;
    private final boolean isEnabled;
    private static Level defaultThreshold = Level.INFO;

    public static final Level getDefaultThreshold() {
        return defaultThreshold;
    }

    public static final void setDefaultThreshold(Level defaultThreshold) {
        JSLogger.defaultThreshold = defaultThreshold != null ? defaultThreshold : Level.INFO;
    }

    private JSLogger(String name, Level threshold) {
        this.name = name;
        this.threshold = threshold;
        this.isEnabled = JSLogger.isEnabled();
    }

    public static final JSLogger getLogger(String name, Level threshold) {
        return new JSLogger(name, threshold);
    }

    public static final JSLogger getLogger(String name) {
        return JSLogger.getLogger(name, defaultThreshold);
    }

    public final void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    public final void info(String message) {
        this.log(Level.INFO, message);
    }

    public final void warn(String message) {
        this.log(Level.WARN, message);
    }

    public final void error(String message) {
        this.log(Level.ERROR, message);
    }

    private final void log(Level level, String message) {
        if (this.isEnabled && level.isHigherThanOrEqualTo(this.threshold)) {
            level.output("[" + new Date() + "][" + level.name() + "][" + this.name + "][" + message + "]");
        }
    }

    public final boolean isDebugEnabled() {
        return Level.DEBUG.isHigherThanOrEqualTo(this.threshold);
    }

    public final boolean isInfoEnabled() {
        return Level.INFO.isHigherThanOrEqualTo(this.threshold);
    }

    public final boolean isWarnEnabled() {
        return Level.WARN.isHigherThanOrEqualTo(this.threshold);
    }

    public final boolean isErrorEnabled() {
        return Level.ERROR.isHigherThanOrEqualTo(this.threshold);
    }

    private static final native boolean isEnabled();

    private static final native void nativeDebug(String var0);

    private static final native void nativeInfo(String var0);

    private static final native void nativeWarn(String var0);

    private static final native void nativeError(String var0);

    public static enum Level {
        DEBUG(0){

            @Override
            public void output(String message) {
                JSLogger.nativeDebug(message);
            }
        }
        ,
        INFO(1){

            @Override
            public void output(String message) {
                JSLogger.nativeInfo(message);
            }
        }
        ,
        WARN(2){

            @Override
            public void output(String message) {
                JSLogger.nativeWarn(message);
            }
        }
        ,
        ERROR(3){

            @Override
            public void output(String message) {
                JSLogger.nativeError(message);
            }
        };

        private final int value;

        private Level(int value) {
            this.value = value;
        }

        protected final int getValue() {
            return this.value;
        }

        protected abstract void output(String var1);

        protected final boolean isHigherThanOrEqualTo(Level level) {
            return this.value >= level.value;
        }
    }
}

