/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ExcelAbstractions;
import org.eaglei.datatools.etl.server.Expression;
import org.eaglei.datatools.etl.server.RdfMakerUtil;
import org.eaglei.datatools.etl.utils.Rdf123Expression;

class ObjectLiteralExpression
extends Expression<Statement[]> {
    private String literalExpression;
    private ExcelAbstractions.ExcelTabData tabData;
    private Statement mapStatement;
    public static final String OBJECT_LITERAL_EXPRESSION_MATCHER = "Ex:$";
    private static Logger logger = Logger.getLogger(ObjectLiteralExpression.class);
    private Rdf123Expression rdf123Exp = null;

    public ObjectLiteralExpression(String literalExpression, Rdf123Expression rdf123Exp, Statement mapStatement) {
        this.literalExpression = literalExpression;
        this.tabData = this.tabData;
        this.mapStatement = mapStatement;
        this.rdf123Exp = rdf123Exp;
    }

    @Override
    public Statement[] interpret(int row) {
        try {
            String result = RdfMakerUtil.evaluateExpression(this.rdf123Exp, row, this.literalExpression.toString());
            if (result == null) {
                return null;
            }
            Model m = ModelFactory.createDefaultModel();
            String[] stringAry = result.split(";");
            Statement[] statementAry = new Statement[stringAry.length];
            int i = 0;
            for (String resultStr : stringAry) {
                Statement stmt;
                statementAry[i] = stmt = m.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), resultStr);
                ++i;
            }
            return statementAry;
        }
        catch (Exception e) {
            logger.error((Object)"Exception has raised in ObjectLiteralExpression's interpret method");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExpressionString() {
        return this.literalExpression;
    }

    @Override
    public Statement getExpressionStatement() {
        return this.mapStatement;
    }
}

