/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.etl.server.RowConfiguration;
import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.security.Session;

public class RDFtoRepoService {
    private static RDFtoRepoService instance = null;
    private DatatoolsConfiguration config;
    RESTRepositoryProvider repoProvider;
    JenaEIInstanceFactory instanceFactory;
    private static final String DEFAULT_CONFIGURATION = "etl-datatools.prop";
    private static final Log logger = LogFactory.getLog(RDFtoRepoService.class);
    private String token;
    private Session session;
    private static final EIEntity defaultCreateTransition = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFT_0"), (String)"Default Create");
    private static final EIEntity sentToCurationTransition = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFT_1"), (String)"Send to Curation");
    private static final EIEntity PublishTransition = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFT_2"), (String)"Publish");

    private RDFtoRepoService(String file, JenaEIInstanceFactory instanceFactory) throws IOException {
        this.instanceFactory = instanceFactory;
        this.config = this.getConfiguration(file);
        this.repoProvider = new RESTRepositoryProvider(this.config, instanceFactory);
    }

    private RDFtoRepoService(JenaEIInstanceFactory instanceFactory) throws IOException, URISyntaxException {
        this.instanceFactory = instanceFactory;
        this.config = this.getConfiguration();
        this.repoProvider = new RESTRepositoryProvider(this.config, instanceFactory);
    }

    public RepositoryProvider getRepositoryProvider() {
        return this.repoProvider;
    }

    public DatatoolsConfiguration getDatatoolsConfiguration() {
        return this.config;
    }

    public static RDFtoRepoService getInstance(String file, JenaEIInstanceFactory instanceFactory) throws IOException {
        if (instance == null) {
            instance = new RDFtoRepoService(file, instanceFactory);
        }
        return instance;
    }

    public static RDFtoRepoService getInstance(JenaEIInstanceFactory instanceFactory) throws Exception {
        if (instance == null) {
            instance = new RDFtoRepoService(instanceFactory);
        }
        return instance;
    }

    public boolean pushtoRepo(Model rdfModel, Session session, String uri, String promoteParameter) throws Exception {
        StringWriter swriter = new StringWriter();
        rdfModel.write((Writer)swriter, "RDF/XML");
        this.repoProvider.createInstance(session, swriter.toString(), uri, RESTRepositoryProvider.DEFAULT_WORKSPACE_ENTITY);
        this.token = this.repoProvider.updateInstance(session, swriter.toString(), uri, null);
        this.repoProvider.updateInstance(session, swriter.toString(), uri, this.token);
        if (promoteParameter.equalsIgnoreCase("publish")) {
            this.repoProvider.transition(session, Arrays.asList(EIURI.create((String)uri)), sentToCurationTransition);
            this.repoProvider.claim(session, Arrays.asList(EIURI.create((String)uri)));
            this.repoProvider.transition(session, Arrays.asList(EIURI.create((String)uri)), PublishTransition);
        } else if (promoteParameter.equalsIgnoreCase("curation")) {
            this.repoProvider.transition(session, Arrays.asList(EIURI.create((String)uri)), defaultCreateTransition);
            this.repoProvider.transition(session, Arrays.asList(EIURI.create((String)uri)), sentToCurationTransition);
            this.repoProvider.release(session, Arrays.asList(EIURI.create((String)uri)));
        } else if (promoteParameter.equalsIgnoreCase("draft")) {
            this.repoProvider.release(session, Arrays.asList(EIURI.create((String)uri)));
        }
        return true;
    }

    public List<EIURI> getNewInstancesFromRepo(Session session, int countofInstances) {
        try {
            return this.repoProvider.getNewInstanceID(session, countofInstances);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RepositoryProvider setPropertyFilePathAndgetNewRepoProvider(String configFilePath) throws IOException {
        File configFile = new File(configFilePath);
        logger.debug((Object)("loading configuration file: " + configFile));
        this.config = new DatatoolsConfiguration(configFile);
        this.repoProvider = new RESTRepositoryProvider(this.config, this.instanceFactory);
        return this.repoProvider;
    }

    private DatatoolsConfiguration getConfiguration(String DEFAULT_CONFIGURATION) {
        try {
            File configFile = new File(DEFAULT_CONFIGURATION);
            logger.debug((Object)("loading configuration file: " + configFile));
            return new DatatoolsConfiguration(configFile);
        }
        catch (Exception e) {
            logger.error((Object)("Error loading configuration from " + DEFAULT_CONFIGURATION + " " + e));
            throw new RuntimeException(e);
        }
    }

    private DatatoolsConfiguration getConfiguration() throws IOException, URISyntaxException {
        URL configURL = this.getClass().getClassLoader().getResource(DEFAULT_CONFIGURATION);
        if (configURL == null) {
            logger.error((Object)"Could not locate etl-datatools.prop on classpath");
            throw new FileNotFoundException("Could not locate etl-datatools.prop on classpath");
        }
        try {
            File configFile = new File(configURL.toURI());
            logger.debug((Object)("loading configuration file: " + configFile));
            return new DatatoolsConfiguration(configFile);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error loading configuration from etl-datatools.prop " + e));
            throw new RuntimeException(e);
        }
    }

    public Session login(String repoPath) throws Exception {
        Map<String, String> credentialMap = RowConfiguration.getCredentialsForRepo(repoPath);
        User strAry = this.repoProvider.login(credentialMap.get("user"), credentialMap.get("password"));
        if (strAry == null) {
            logger.error((Object)"Could not authenticate please check username,password and Repository URL...Exiting System");
            System.exit(2);
        }
        this.setSession(strAry.getSession());
        return this.getSession();
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

