/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.Expression;
import org.eaglei.datatools.etl.server.RDFtoRepoService;
import org.eaglei.datatools.etl.server.RdfMaker;
import org.eaglei.datatools.etl.server.RdfMakerUtil;
import org.eaglei.datatools.etl.utils.Rdf123Expression;

class SemiColonExpresson
extends Expression<Model[]> {
    public static final String SEMICOLON_MATCHER = ";";
    private Model mapModel;
    private static Logger logger = Logger.getLogger(SemiColonExpresson.class);
    private Rdf123Expression rdf123Exp = null;
    private RDFtoRepoService rdftorepo;

    public SemiColonExpresson(Model mapModel, Rdf123Expression rdf123Exp) {
        this.mapModel = mapModel;
        this.rdftorepo = RdfMaker.getRdftorepo();
        String base = this.rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
        this.rdf123Exp = rdf123Exp;
    }

    @Override
    public Model[] interpret(int row) {
        try {
            HashMap<String, String[]> objectLiteralMap = new HashMap<String, String[]>();
            int largestArraySize = 0;
            Model[] modelAryToReturn = null;
            StmtIterator stmtIterator = this.mapModel.listStatements();
            while (stmtIterator.hasNext()) {
                String result;
                Literal objectLiteral;
                Statement stmtMap = stmtIterator.nextStatement();
                Property predicate = stmtMap.getPredicate();
                RDFNode rdfNode = stmtMap.getObject();
                if (rdfNode.isResource() || !(objectLiteral = (Literal)rdfNode).toString().contains("$") || (result = RdfMakerUtil.evaluateExpression(this.rdf123Exp, row, objectLiteral.toString())) == null) continue;
                String[] stringSplitAry = result.split(SEMICOLON_MATCHER);
                if (stringSplitAry.length > 1) {
                    objectLiteralMap.put(predicate.toString(), stringSplitAry);
                }
                if (stringSplitAry.length <= largestArraySize) continue;
                largestArraySize = stringSplitAry.length;
            }
            if (largestArraySize > 0) {
                modelAryToReturn = new Model[largestArraySize];
                for (int i = 0; i <= largestArraySize - 1; ++i) {
                    Model model = ModelFactory.createDefaultModel();
                    StmtIterator iter = this.mapModel.listStatements();
                    while (iter.hasNext()) {
                        Statement stmtMap = iter.nextStatement();
                        Resource subject = stmtMap.getSubject();
                        Property predicate = stmtMap.getPredicate();
                        if (objectLiteralMap.containsKey(predicate.toString())) {
                            model.add(subject, predicate, ((String[])objectLiteralMap.get(predicate.toString()))[i]);
                            continue;
                        }
                        model.add(stmtMap);
                    }
                    modelAryToReturn[i] = model;
                }
                return modelAryToReturn;
            }
            return new Model[]{this.mapModel};
        }
        catch (Exception e) {
            logger.error((Object)" Exception Occured in interpret method of SemiColonExpresson class");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExpressionString() {
        return SEMICOLON_MATCHER;
    }

    @Override
    public Statement getExpressionStatement() {
        return null;
    }
}

