/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.extractor;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.eaglei.datatools.etl.server.exceptions.UnsupportedFileException;
import org.eaglei.datatools.etl.server.extractor.ExcelExtractor;
import org.eaglei.datatools.etl.server.extractor.Extractor;
import org.eaglei.datatools.etl.server.extractor.XmlExtractor;
import org.xml.sax.SAXException;

public class ExtractorFactory {
    public static Extractor getExtractor(File file) throws ParseException, ParserConfigurationException, SAXException, IOException, UnsupportedFileException {
        ExtractorType extention = ExtractorFactory.getExtention(file);
        if (extention == ExtractorType.excel || extention == ExtractorType.excel2003) {
            return new ExcelExtractor(file);
        }
        if (extention == ExtractorType.xml) {
            return new XmlExtractor(file, "biositemaps_v1");
        }
        throw new UnsupportedFileException(file.getName() + " is not supported by ETL yet,please send a request at admin@eagle-i.org");
    }

    private static ExtractorType getExtention(File file) throws UnsupportedFileException {
        String fileName = file.getName();
        int mid = fileName.lastIndexOf(".");
        String fname = fileName.substring(0, mid);
        String ext = fileName.substring(mid + 1, fileName.length());
        if (ext.equals(ExtractorType.excel.getExtension())) {
            return ExtractorType.excel;
        }
        if (ext.equals(ExtractorType.excel2003.getExtension())) {
            return ExtractorType.excel2003;
        }
        if (ext.equals(ExtractorType.xml.getExtension()) || ext.equals(ExtractorType.rdf.getExtension())) {
            return ExtractorType.xml;
        }
        if (ext.equals(ExtractorType.csv.getExtension())) {
            return ExtractorType.csv;
        }
        if (ext.equals(ExtractorType.tsv.getExtension())) {
            return ExtractorType.tsv;
        }
        if (ext.equals(ExtractorType.json.getExtension())) {
            return ExtractorType.json;
        }
        throw new UnsupportedFileException(file.getName() + " is not supported by ETL yet,please send a request at admin@eagle-i.org");
    }

    public static enum ExtractorType {
        excel("xls"),
        excel2003("xlsx"),
        xml("xml"),
        csv("csv"),
        tsv("tsv"),
        json("json"),
        rdf("rdf");

        private String fileExtension;

        private ExtractorType(String fileExtention) {
            this.fileExtension = fileExtention;
        }

        public String getExtension() {
            return this.fileExtension;
        }
    }
}

