/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.interim.cores.OldFileUtils;
import org.eaglei.datatools.model.DataToolsOntConstants;

public class CmapToRDF {
    private static final Log logger = LogFactory.getLog(CmapToRDF.class);
    private static boolean isDebugEnabled = logger.isDebugEnabled();

    public static void main(String[] args) throws IOException, URISyntaxException {
        if (args.length <= 1 || args[0].length() == 0 || args[1].length() == 0) {
            logger.error((Object)"CmapToRDF <input dir> <output dir>");
            return;
        }
        CmapToRDF.processAll(args[0], args[1]);
    }

    private static void processAll(String inputPath, String outputPath) throws IOException, URISyntaxException {
        File inputDir = new File(inputPath);
        logger.info((Object)("Reading cmap text files from directory: " + inputDir.getAbsolutePath()));
        OldFileUtils.validateDirectory(inputDir, false);
        List<File> files = OldFileUtils.getAllFiles(inputDir);
        for (File file : files) {
            String cmapFile = file.getAbsolutePath();
            if (!cmapFile.endsWith(".txt")) continue;
            try {
                CmapToRDF.generateToFile(cmapFile, outputPath);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to process file: " + cmapFile));
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateToFile(String cmapFile, String outputPath) throws IOException, URISyntaxException {
        Model model = CmapToRDF.generateToModel(cmapFile);
        File outputDir = new File(outputPath);
        OldFileUtils.validateDirectory(outputDir, true);
        logger.info((Object)("Writing RDF/XML file to directory: " + outputDir.getAbsolutePath()));
        String extension = ".rdf";
        File nn = new File(cmapFile);
        int i = nn.getName().lastIndexOf(".");
        String rdfFile = i > 0 ? nn.getName().substring(0, i) + extension : nn.getName() + extension;
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputDir, rdfFile)), "UTF-8");
        try {
            model.write((Writer)out);
            out.flush();
        }
        finally {
            out.close();
        }
        logger.info((Object)"Done!");
        logger.info((Object)"============");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model generateToModel(String cmapFile) throws IOException, URISyntaxException {
        logger.info((Object)("Processing file: " + cmapFile));
        if (cmapFile == null || cmapFile.length() == 0 || !cmapFile.endsWith(".txt")) {
            logger.error((Object)"File name null or empty");
            throw new IllegalArgumentException("File name null or empty");
        }
        Model model = ModelFactory.createDefaultModel();
        Scanner scanner = new Scanner(new File(cmapFile), "UTF-8");
        StringBuilder sb = new StringBuilder();
        String NL = System.getProperty("line.separator");
        try {
            while (scanner.hasNextLine()) {
                String completeLine = scanner.nextLine();
                if (isDebugEnabled) {
                    logger.debug((Object)("Processing line: " + completeLine));
                }
                if (completeLine.startsWith("Template") || completeLine.length() == 0) continue;
                String line = completeLine.replaceAll("\\[[.[^\\]]]*\\]", "");
                if (isDebugEnabled) {
                    logger.debug((Object)("Pruned line: " + line));
                }
                StringTokenizer t = new StringTokenizer(line);
                ArrayList<String> triple = new ArrayList<String>();
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    if (isDebugEnabled) {
                        logger.debug((Object)("Processing token: " + token));
                    }
                    triple.add(token);
                }
                if (triple.size() != 3) {
                    throw new RuntimeException("Input line does not represent a triple: " + line);
                }
                String subject = CmapToRDF.replacePrefix(((String)triple.get(0)).trim());
                String predicate = CmapToRDF.replacePrefix(((String)triple.get(1)).trim());
                String object = CmapToRDF.replacePrefix(((String)triple.get(2)).trim());
                model.setNsPrefixes(DataToolsOntConstants.nameSpaceMap);
                Resource subjectResource = model.createResource(subject);
                Property predicateProperty = model.createProperty(predicate);
                Object objectNode = object.contains("^^") || !object.contains(":") ? model.createLiteral(object) : model.createResource(object);
                model.add(model.createStatement(subjectResource, predicateProperty, (RDFNode)objectNode));
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return model;
    }

    private static final String replacePrefix(String string) {
        if (isDebugEnabled) {
            logger.debug((Object)("Replacing namespace prefix in string: " + string));
        }
        for (Map.Entry entry : DataToolsOntConstants.nameSpaceMap.entrySet()) {
            if (!string.contains((String)entry.getKey() + ":")) continue;
            String result = string.replace((String)entry.getKey() + ":", (CharSequence)entry.getValue());
            if (isDebugEnabled) {
                logger.debug((Object)("Returning reoplacement: " + result));
            }
            return result;
        }
        return string;
    }
}

