/**
 * eagle-i Project
 * Harvard University
 * Feb 15, 2010
 */
package org.eaglei.datatools.interim.gsites;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.gdata.util.ServiceException;

/**
 * @author dbw
 *
 */
public class DownloadDropboxForRnav {
	private static final Log logger = LogFactory
		.getLog(DownloadDropboxForRnav.class);
	
	/**
	 * @param args base output path
	 * @throws ServiceException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException, ServiceException {
        if (args.length < 2 || args[0].length() == 0 || args[1].length() == 0) {
            logger.error("DownloadDropboxForRnav <rnav> <base output path> [mode]");
            return;
        }
        if(args.length > 2)
        	download(args[0], args[1], args[2]);
        else
        	download(args[0], args[1], null);
        
        logger.debug("Done!");
	}
	
    private static void download(String rnav, String path, String mode) throws IOException, ServiceException {
    		GSitesUtils.login();
    		boolean delete = false;
    		if (mode != null)
    			if("delete".equals(mode)) {
    				delete = true;
    				if(logger.isDebugEnabled()) logger.debug("Mode is set to delete");
    			}
    		//Download and delete
    		GSitesUtils.getDropboxForRnav(rnav, path, delete);
    		
        }



}
