package org.eaglei.datatools.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIOntModel;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;

@Configuration
public class DataToolsModelConfig {
    
    private static final Log logger = LogFactory.getLog(DataToolsModelConfig.class);

    private @Autowired OntDocumentManager jenaOntDocumentManager;
    private @Autowired EIOntModel eagleiOntModel;

    
   //Uncomment to load datatools ontology (remember to modify ont-policy.rdf with the namespace to file mapping)
/*    public @Bean OntModel datatoolsJenaOntModel() {
        long start;      
        logger.info("loading datatools ontology...");
        start = System.currentTimeMillis();
        OntModel model = jenaOntDocumentManager.getOntology(DataToolsOntConstants.EAGLE_I_DT_URI, PelletReasonerFactory.THE_SPEC);
        logger.info("datatools ontology loaded:  " + (System.currentTimeMillis()-start) + "msec");
        return model;
    }*/
    
    /**
     * Create wrapper that has datatools specific behavior.
     * Also stores instance in a static for convenient access.
     * 
     * @return
     */
    public @Bean DataToolsOntModelUtils.EIOntModelWrapper datatoolsEIOntModel() {
        return new DataToolsOntModelUtils.EIOntModelWrapper(eagleiOntModel);
    }
}
