import sys
import pycurl
import urllib
from repoUtils import getUPass, RepoCurler

class Promoter:
    def __init__(self, repoUrl, queryType, newState, user):
        self.repoUrl = repoUrl 
        self.user = user
        self.curler = RepoCurler(self.repoUrl, self.user)
        
        
        # map short names to new state
        self.stateMap = {'curation':'http://eagle-i.org/ont/repo/1.0/WFS_Curation',
                         'http://eagle-i.org/ont/repo/1.0/WFS_Curation':'http://eagle-i.org/ont/repo/1.0/WFS_Curation',
                         'publish':'http://eagle-i.org/ont/repo/1.0/WFS_Published',
                         'http://eagle-i.org/ont/repo/1.0/WFS_Published':'http://eagle-i.org/ont/repo/1.0/WFS_Published',
                         'withdraw':'http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn',
                         'http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn':'http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn',
                         'delete':'delete'}
        
        self.actionMap = {'ct':'ERO_0000015',
                          'ERO_0000015':'ERO_0000015',
                          'reagents':'ERO_0000006',
                          'reagent':'ERO_0000006',
                          'ERO_0000006':'ERO_0000006'}
        
        self.resourceType = self.actionMap[queryType]
        print self.resourceType
        
        self.newState = self.stateMap[newState.lower()]
        print self.newState
        
        self.urlquery = 'select ?s where {?s a <http://purl.obolibrary.org/obo/' + self.resourceType + '> .}'
    
    def getUris(self):
        formcontents = [('format', 'text/plain'),
                        ('view', 'user'),
                        ('query', self.urlquery)]
                        #('query', 'select ?s where {?s a <http://purl.obolibrary.org/obo/' + self.resourceType + '> .}')]
        
        self.curler.makeNewRequest("/sparql")

        self.curler.setopt(pycurl.HTTPPOST, formcontents)
    
        try:
            content = self.curler.getResult()
        except:
            content = 'error doing curl!'
        
        content = content.split('\n')
        
        uris = []
        for line in content:
            line = line.rstrip()
            if not line.startswith('s') and len(line) > 0:
                uris.append(line)
        
        print uris
        return uris
    
    def promoteAll(self):
        uris = self.getUris()
        
        if self.newState == 'delete':
            for uri in uris:
                self.delete(uri)
        else:
            for uri in uris:
                self.promote(uri)
            
    
    def promote(self, uri):
        print 'promoting ' + uri + ' to ' + self.newState
        
        postfields = 'promote='+self.newState+'&uri='+uri
        
        #print postfields
                
        self.curler.makeNewRequest("/fakeworkflow")
        self.curler.setopt(pycurl.POSTFIELDS, postfields)
        
        
        result = self.curler.getResult()
        print result
        
        print self.curler.getinfo(pycurl.HTTP_CODE)
 
    def delete(self, uri):
        self.curler.makeNewRequest('/update')
        self.curler.setopt(pycurl.HTTPPOST, [('action','gettoken'), ('format','text/plain'), ('uri',uri)])
        tokenplus = self.curler.getResult()
        
        token = tokenplus.split('\n')[1].split()[0]
        
        self.curler.makeNewRequest('/update')
        self.curler.setopt(pycurl.HTTPPOST, [('action','update'), ('format','text/plain'), ('uri',uri), ('token', token),
                                        ('delete', '<' + uri + '> <http://eagle-i.org/ont/repo/1.0/MatchAnything> <http://eagle-i.org/ont/repo/1.0/MatchAnything> .')])
        result = self.curler.getResult()
        print result
    
def main():
    if len(sys.argv) != 5:
        print "Takes 4 arguments: repository URL, [indicator of type], new state name or url, and user name (assumes password same)"
    promoter = Promoter(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])
    promoter.promoteAll()

if __name__ == '__main__':
    main()
        